/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Profile;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class RequireActiveProfile
extends AbstractNonCacheableEnforcerRule {
    public String profiles = null;
    public boolean all = true;

    public void execute(EnforcerRuleHelper theHelper) throws EnforcerRuleException {
        ArrayList<String> missingProfiles = new ArrayList<String>();
        try {
            MavenProject project = (MavenProject)theHelper.evaluate("${project}");
            if (StringUtils.isNotEmpty((String)this.profiles)) {
                String[] profs = this.profiles.split(",");
                for (int i = 0; i < profs.length; ++i) {
                    if (this.isProfileActive(project, profs[i])) continue;
                    missingProfiles.add(profs[i]);
                }
                boolean fail = false;
                if (!missingProfiles.isEmpty()) {
                    fail = true;
                }
                if (fail) {
                    StringBuffer buf = new StringBuffer();
                    if (this.message != null) {
                        buf.append(this.message + "\n");
                    }
                    Iterator iter = missingProfiles.iterator();
                    while (iter.hasNext()) {
                        buf.append("Profile \"" + iter.next().toString() + "\" is not activated.\n");
                    }
                    throw new EnforcerRuleException(buf.toString());
                }
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to retrieve the project.", (Exception)((Object)e));
        }
    }

    protected boolean isProfileActive(MavenProject project, String profileName) {
        List activeProfiles = project.getActiveProfiles();
        if (activeProfiles != null && !activeProfiles.isEmpty()) {
            Iterator it = activeProfiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                if (!profile.getId().equals(profileName)) continue;
                return true;
            }
        }
        return false;
    }
}

