/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.EnforcerRuleUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RequireNoRepositories
extends AbstractNonCacheableEnforcerRule {
    public boolean banRepositories = true;
    public boolean banPluginRepositories = true;
    public List allowedRepositories = Collections.EMPTY_LIST;
    public List allowedPluginRepositories = Collections.EMPTY_LIST;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerRuleUtils utils = new EnforcerRuleUtils(helper);
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List models = utils.getModelsRecursively(project.getGroupId(), project.getArtifactId(), project.getVersion(), new File(project.getBasedir(), "pom.xml"));
            ArrayList<Model> badModels = new ArrayList<Model>();
            StringBuffer newMsg = new StringBuffer();
            newMsg.append("Some poms have repositories defined:\n");
            Iterator i = models.iterator();
            while (i.hasNext()) {
                List bannedRepos;
                List repos;
                Model model = (Model)i.next();
                if (this.banRepositories && (repos = model.getRepositories()) != null && !repos.isEmpty() && !(bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedRepositories)).isEmpty()) {
                    badModels.add(model);
                    newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has repositories " + bannedRepos);
                }
                if (!this.banPluginRepositories || (repos = model.getPluginRepositories()) == null || repos.isEmpty() || (bannedRepos = RequireNoRepositories.findBannedRepositories(repos, this.allowedPluginRepositories)).isEmpty()) continue;
                badModels.add(model);
                newMsg.append(model.getGroupId() + ":" + model.getArtifactId() + " version:" + model.getVersion() + " has plugin repositories " + bannedRepos);
            }
            if (!badModels.isEmpty()) {
                if (StringUtils.isNotEmpty((String)this.message)) {
                    newMsg.append(this.message);
                }
                throw new EnforcerRuleException(newMsg.toString());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
        catch (XmlPullParserException e) {
            throw new EnforcerRuleException(e.getLocalizedMessage());
        }
    }

    private static List findBannedRepositories(List repos, List allowedRepos) {
        ArrayList<String> bannedRepos = new ArrayList<String>(allowedRepos.size());
        Iterator i = repos.iterator();
        while (i.hasNext()) {
            Repository r = (Repository)i.next();
            if (allowedRepos.contains(r.getId())) continue;
            bannedRepos.add(r.getId());
        }
        return bannedRepos;
    }
}

