/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractBanDependencies;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireReleaseDeps
extends AbstractBanDependencies {
    public boolean onlyWhenRelease = false;
    public boolean failWhenParentIsSnapshot = true;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = null;
        boolean callSuper = this.onlyWhenRelease ? !(project = this.getProject(helper)).getArtifact().isSnapshot() : true;
        if (callSuper) {
            super.execute(helper);
            if (this.failWhenParentIsSnapshot) {
                Artifact parentArtifact;
                if (project == null) {
                    project = this.getProject(helper);
                }
                if ((parentArtifact = project.getParentArtifact()) != null && parentArtifact.isSnapshot()) {
                    throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
                }
            }
        }
    }

    private MavenProject getProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
    }

    protected Set checkDependencies(Set dependencies, Log log) throws EnforcerRuleException {
        HashSet<Artifact> foundExcludes = new HashSet<Artifact>();
        Iterator DependencyIter = dependencies.iterator();
        while (DependencyIter.hasNext()) {
            Artifact artifact = (Artifact)DependencyIter.next();
            if (!artifact.isSnapshot()) continue;
            foundExcludes.add(artifact);
        }
        return foundExcludes;
    }

    public boolean isOnlyWhenRelease() {
        return this.onlyWhenRelease;
    }

    public void setOnlyWhenRelease(boolean onlyWhenRelease) {
        this.onlyWhenRelease = onlyWhenRelease;
    }

    public boolean isFailWhenParentIsSnapshot() {
        return this.failWhenParentIsSnapshot;
    }

    public void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }
}

