/*
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.mobicents.servlet.sip.startup.loading.rules;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.sip.SipServletRequest;

/**
 * @author Thomas Leseney
 */
public class AndRule implements MatchingRule {
	
    private List<MatchingRule> criteria = new ArrayList<MatchingRule>();
    
    public AndRule() { }
    
    public void addCriterion(MatchingRule c) {
       criteria.add(c); 
    }
    
    public boolean matches(SipServletRequest request) {
        for (MatchingRule rule : criteria) {
            if (!rule.matches(request)) 
                return false;
        }
        return true;
    }

    public String getExpression() {
        StringBuffer sb = new StringBuffer("(");
        boolean first = true;
         
        for (MatchingRule rule : criteria) {
            if (first) { 
                first = false;
            } else { 
                sb.append(" and ");
            }
            sb.append(rule.getExpression());
        }
        sb.append(")");
        return sb.toString();
    }
}
