package org.mobicents.slee.container.component;

import java.util.List;

import org.mobicents.slee.container.component.SleeComponentWithUsageParametersInterface;
import org.mobicents.slee.container.component.UsageParameterDescriptor;

public abstract class AbstractSleeComponentWithUsageParametersInterface extends AbstractSleeComponent implements SleeComponentWithUsageParametersInterface {

	/**
	 * the usage parameters interface
	 */
	private Class<?> usageParametersInterface;
	
	/**
	 * the concrete usage parameters class, generated by SLEE
	 */
	private Class<?> usageParametersConcreteClass;

	/**
	 * the concrete usage parameters mbean interface, generated by SLEE
	 */
	private Class<?> usageParametersMBeanConcreteInterface;
	
	/**
	 * the concrete usage parameters mbean impl class, generated by SLEE
	 */
	private Class<?> usageParametersMBeanImplConcreteClass;
	
	/**
	 * the concrete usage notification manager mbean interface, generated by SLEE
	 */
	private Class<?> usageNotificationManagerMBeanConcreteInterface;
	
	/**
	 * the concrete usage notification manager mbean impl class, generated by SLEE
	 */
	private Class<?> usageNotificationManagerMBeanImplConcreteClass;
	
	/**
	 * Retrieves the usage parameters interface
	 * 
	 * @return
	 */
	public Class<?> getUsageParametersInterface() {
		return usageParametersInterface;
	}

	/**
	 * Sets the usage parameters interface
	 * 
	 * @param usageParametersInterface
	 */
	public void setUsageParametersInterface(Class<?> usageParametersInterface) {
		this.usageParametersInterface = usageParametersInterface;
	}

	/**
	 * Retrieves the concrete usage parameters class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersConcreteClass() {
		return usageParametersConcreteClass;
	}
	
	/**
	 * Sets the concrete usage parameters class, generated by SLEE
	 * @param usageParametersConcreteClass
	 */
	public void setUsageParametersConcreteClass(
			Class<?> usageParametersConcreteClass) {
		this.usageParametersConcreteClass = usageParametersConcreteClass;
	}
	
	/**
	 * Retrieves the concrete usage parameters mbean interface, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersMBeanConcreteInterface() {
		return usageParametersMBeanConcreteInterface;
	}
	
	/**
	 * Sets the concrete usage parameters mbean interface, generated by SLEE
	 * @param usageParametersMBeanConcreteInterface
	 */
	public void setUsageParametersMBeanConcreteInterface(
			Class<?> usageParametersMBeanConcreteInterface) {
		this.usageParametersMBeanConcreteInterface = usageParametersMBeanConcreteInterface;
	}
	
	/**
	 * Retrieves the concrete usage parameters mbean impl class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersMBeanImplConcreteClass() {
		return usageParametersMBeanImplConcreteClass;
	}
	
	/**
	 * Sets the concrete usage parameters mbean impl class, generated by SLEE
	 * @param usageParametersMBeanImplConcreteClass
	 */
	public void setUsageParametersMBeanImplConcreteClass(
			Class<?> usageParametersMBeanImplConcreteClass) {
		this.usageParametersMBeanImplConcreteClass = usageParametersMBeanImplConcreteClass;
	}
	
	/**
	 * Retrieves the concrete usage notification manager mbean interface, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageNotificationManagerMBeanConcreteInterface() {
		return usageNotificationManagerMBeanConcreteInterface;
	}
	
	/**
	 * Sets the concrete usage notification manager mbean interface, generated by SLEE
	 * @param usageNotificationManagerMBeanConcreteInterface
	 */
	public void setUsageNotificationManagerMBeanConcreteInterface(
			Class<?> usageNotificationManagerMBeanConcreteInterface) {
		this.usageNotificationManagerMBeanConcreteInterface = usageNotificationManagerMBeanConcreteInterface;
	}
	
	/**
	 * Retrieves the concrete usage notification manager mbean impl class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageNotificationManagerMBeanImplConcreteClass() {
		return usageNotificationManagerMBeanImplConcreteClass;
	}
	
	/**
	 * Sets the concrete usage notification manager mbean impl class, generated by SLEE
	 * @param usageNotificationManagerMBeanImplConcreteClass
	 */
	public void setUsageNotificationManagerMBeanImplConcreteClass(
			Class<?> usageNotificationManagerMBeanImplConcreteClass) {
		this.usageNotificationManagerMBeanImplConcreteClass = usageNotificationManagerMBeanImplConcreteClass;
	}

	/*
	 * (non-Javadoc)
	 * @see org.mobicents.slee.core.component.SleeComponentWithUsageParametersInterface#getUsageParametersList()
	 */
	public abstract List<UsageParameterDescriptor> getUsageParametersList();
	
	/*
	 * (non-Javadoc)
	 * @see org.mobicents.slee.container.component.AbstractSleeComponent#undeployed()
	 */
	@Override
	public void undeployed() {
		super.undeployed();
		usageNotificationManagerMBeanConcreteInterface = null;
		usageNotificationManagerMBeanImplConcreteClass = null;
		usageParametersConcreteClass = null;
		usageParametersInterface = null;
		usageParametersMBeanConcreteInterface = null;
		usageParametersMBeanImplConcreteClass = null;
	}
}
