/**
 * 
 */
package org.mobicents.slee.container.component.ratype;

import javax.slee.resource.ResourceAdaptorTypeID;

import org.mobicents.slee.container.component.SleeComponent;

/**
 * 
 * @author martins
 * 
 */
public interface ResourceAdaptorTypeComponent extends SleeComponent {

	/**
	 * Retrieves the component's descriptor.
	 * @return
	 */
	public ResourceAdaptorTypeDescriptor getDescriptor();
	
	/**
	 * Retrieves the instance of the aci factory for this ra type
	 * 
	 * @return
	 */
	public Object getActivityContextInterfaceFactory();

	/**
	 * Retrieves the aci factory concrete class, generated by SLEE
	 * 
	 * @return
	 */
	public Class<?> getActivityContextInterfaceFactoryConcreteClass();

	/**
	 * Retrieves the aci factory interface
	 * 
	 * @return
	 */
	public Class<?> getActivityContextInterfaceFactoryInterface();

	/**
	 * 
	 * @return
	 */
	public Class<?> getResourceAdaptorSBBInterface();

	/**
	 * Retrieves the ratype id
	 * 
	 * @return
	 */
	public ResourceAdaptorTypeID getResourceAdaptorTypeID();

	/**
	 * Retrieves the JAIN SLEE specs descriptor
	 * 
	 * @return
	 */
	public javax.slee.resource.ResourceAdaptorTypeDescriptor getSpecsDescriptor();

	/**
	 * Sets the instance of the aci factory for this ra type
	 * 
	 * @param o
	 */
	public void setActivityContextInterfaceFactory(Object o);

	/**
	 * Sets the aci factory concrete class, generated by SLEE
	 * 
	 * @param c
	 */
	public void setActivityContextInterfaceFactoryConcreteClass(Class<?> c);

	/**
	 * Sets the aci factory interface
	 * 
	 * @param c
	 */
	public void setActivityContextInterfaceFactoryInterface(Class<?> c);

	/**
	 * 
	 * @param c
	 */
	public void setResourceAdaptorSBBInterface(Class<?> c);

}
