/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a full listing
 * of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */
package net.java.slee.resource.diameter.sh.events.avp.userdata;

import java.util.List;

import org.mobicents.slee.resource.diameter.sh.events.avp.userdata.TExtension;
import org.mobicents.slee.resource.diameter.sh.events.avp.userdata.TISDNAddress;
import org.w3c.dom.Element;

/**
 * <p>Interface for tCSLocationInformation complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="tCSLocationInformation">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="LocationNumber" type="{}tLocationNumber" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element name="CellGlobalId" type="{}tCellGlobalId" minOccurs="0"/>
 *           &lt;element name="ServiceAreaId" type="{}tServiceAreaId" minOccurs="0"/>
 *           &lt;element name="LocationAreaId" type="{}tLocationAreaId" minOccurs="0"/>
 *         &lt;/choice>
 *         &lt;element name="GeographicalInformation" type="{}tGeographicalInformation" minOccurs="0"/>
 *         &lt;element name="GeodeticInformation" type="{}tGeodeticInformation" minOccurs="0"/>
 *         &lt;element name="VLRNumber" type="{}tISDNAddress" minOccurs="0"/>
 *         &lt;element name="MSCNumber" type="{}tISDNAddress" minOccurs="0"/>
 *         &lt;element name="CurrentLocationRetrieved" type="{}tBool" minOccurs="0"/>
 *         &lt;element name="AgeOfLocationInformation" type="{}tAgeOfLocationInformation" minOccurs="0"/>
 *         &lt;element name="Extension" type="{}tExtension" minOccurs="0"/>
 *         &lt;any processContents='lax' namespace='##other' maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * @author <a href="mailto:brainslog@gmail.com"> Alexandre Mendonca </a>
 */
public interface CSLocationInformation {

  /**
   * Gets the value of the locationNumber property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getLocationNumber();

  /**
   * Sets the value of the locationNumber property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setLocationNumber(String value);

  /**
   * Gets the value of the cellGlobalId property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getCellGlobalId();

  /**
   * Sets the value of the cellGlobalId property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setCellGlobalId(String value);

  /**
   * Gets the value of the serviceAreaId property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getServiceAreaId();

  /**
   * Sets the value of the serviceAreaId property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setServiceAreaId(String value);

  /**
   * Gets the value of the locationAreaId property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getLocationAreaId();

  /**
   * Sets the value of the locationAreaId property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setLocationAreaId(String value);

  /**
   * Gets the value of the geographicalInformation property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getGeographicalInformation();

  /**
   * Sets the value of the geographicalInformation property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setGeographicalInformation(String value);

  /**
   * Gets the value of the geodeticInformation property.
   * 
   * @return
   *     possible object is
   *     {@link String }
   *     
   */
  public abstract String getGeodeticInformation();

  /**
   * Sets the value of the geodeticInformation property.
   * 
   * @param value
   *     allowed object is
   *     {@link String }
   *     
   */
  public abstract void setGeodeticInformation(String value);

  /**
   * Gets the value of the vlrNumber property.
   * 
   * @return
   *     possible object is
   *     {@link TISDNAddress }
   *     
   */
  public abstract ISDNAddress getVLRNumber();

  /**
   * Sets the value of the vlrNumber property.
   * 
   * @param value
   *     allowed object is
   *     {@link TISDNAddress }
   *     
   */
  public abstract void setVLRNumber(ISDNAddress value);

  /**
   * Gets the value of the mscNumber property.
   * 
   * @return
   *     possible object is
   *     {@link TISDNAddress }
   *     
   */
  public abstract ISDNAddress getMSCNumber();

  /**
   * Sets the value of the mscNumber property.
   * 
   * @param value
   *     allowed object is
   *     {@link TISDNAddress }
   *     
   */
  public abstract void setMSCNumber(ISDNAddress value);

  /**
   * Gets the value of the currentLocationRetrieved property.
   * 
   * @return
   *     possible object is
   *     {@link Boolean }
   *     
   */
  public abstract Boolean isCurrentLocationRetrieved();

  /**
   * Sets the value of the currentLocationRetrieved property.
   * 
   * @param value
   *     allowed object is
   *     {@link Boolean }
   *     
   */
  public abstract void setCurrentLocationRetrieved(Boolean value);

  /**
   * Gets the value of the ageOfLocationInformation property.
   * 
   * @return
   *     possible object is
   *     {@link Integer }
   *     
   */
  public abstract Integer getAgeOfLocationInformation();

  /**
   * Sets the value of the ageOfLocationInformation property.
   * 
   * @param value
   *     allowed object is
   *     {@link Integer }
   *     
   */
  public abstract void setAgeOfLocationInformation(Integer value);

  /**
   * Gets the value of the extension property.
   * 
   * @return
   *     possible object is
   *     {@link TExtension }
   *     
   */
  public abstract Extension getExtension();

  /**
   * Sets the value of the extension property.
   * 
   * @param value
   *     allowed object is
   *     {@link TExtension }
   *     
   */
  public abstract void setExtension(Extension value);

  /**
   * Gets the value of the any property.
   * 
   * <p>
   * This accessor method returns a reference to the live list,
   * not a snapshot. Therefore any modification you make to the
   * returned list will be present inside the JAXB object.
   * This is why there is not a <CODE>set</CODE> method for the any property.
   * 
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getAny().add(newItem);
   * </pre>
   * 
   * 
   * <p>
   * Objects of the following type(s) are allowed in the list
   * {@link Object }
   * {@link Element }
   * 
   * 
   */
  public abstract List<Object> getAny();

}