/*
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.servlet.sip;
/**
 * Listener interface implemented by SIP servlet applications using timers.
 * The application specifies an implementation of this interface in a listener element of the SIP deployment descriptor. There may be at most one TimerListener defined.
 * See Also:TimerService
 */
public interface TimerListener extends java.util.EventListener{
    /**
     * Notifies the listener that the specified timer has expired.
     */
    void timeout(javax.servlet.sip.ServletTimer timer);

}
