/*
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.servlet.sip.ar;

/**
 * Type of targeted request
 *  
 * @since 1.1
 */
public enum SipTargetedRequestType {

	/**
	 * The request contains a Request-URI that contains an encoded URI 
	 */
	ENCODED_URI,
	/**
	 * The request contains a Join header (RFC 3911) 
	 */
	JOIN,
	/**
	 * The request contains a Replaces header (RFC 3891) 
	 */
	REPLACES;
}
