/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.protocols.ss7.mtp;


/**
 *
 * @author kulikov
 */
public abstract class MTPTask implements Runnable {

    protected boolean canceled = false;
    protected long deadLine;
    protected int index;
    protected MTPScheduler scheduler;
    public void run() {
        if (!canceled) {
        	try{
        		//exception in caught in scheduler.
        		perform();
        	}finally
        	{
        		canceled = true;
        	}
        }
        
    }

    public boolean isCanceled() {
        return this.canceled;
    }
    
    public abstract void perform();
    
    public void cancel() {
        this.canceled = true;
        //dont do this, let it be lazely reclaimed if ever, this causes race!
        //remove task from list
        //if (scheduler != null && (index >=0) && (index < scheduler.tasks.length)) {
        //    scheduler.tasks[index] = null;  
        //}
    }
}
