/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.slee.container.component;

import java.util.Set;

import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DependencyException;
import javax.slee.management.DeploymentException;
import javax.slee.management.LibraryID;
import javax.slee.resource.ResourceAdaptorTypeID;

import org.mobicents.slee.container.component.deployment.jaxb.descriptors.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.container.component.ratype.ResourceAdaptorTypeComponent;

/**
 * Start time:00:45:05 2009-02-04<br>
 * Project: mobicents-jainslee-server-core<br>
 * 
 * @author <a href="mailto:baranowb@gmail.com">baranowb - Bartosz Baranowski
 *         </a>
 * @author <a href="mailto:brainslog@gmail.com"> Alexandre Mendonca </a>
 */
public class ResourceAdaptorTypeComponentImpl extends AbstractSleeComponent implements ResourceAdaptorTypeComponent {

	/**
	 * the ratype descriptor
	 */
	private final ResourceAdaptorTypeDescriptorImpl descriptor;
	
	/**
	 * the aci factory interface
	 */
	private Class<?> activityContextInterfaceFactoryInterface;
	
	/**
	 * the aci factory concrete class, generated by SLEE
	 */
	private Class<?> activityContextInterfaceFactoryConcreteClass;
	  /**
	   * Resource adaptor SBB interface
	   */
	private Class<?> resourceAdaptorSBBInterface = null;
	
	/**
	 * the JAIN SLEE specs descriptor
	 */
	private javax.slee.resource.ResourceAdaptorTypeDescriptor specsDescriptor = null;
	
	/**
	 * the instance of the aci factory for this ra type
	 */
	private Object activityContextInterfaceFactory;
	
	/**
	 * 
	 * @param descriptor
	 */
	public ResourceAdaptorTypeComponentImpl(
			ResourceAdaptorTypeDescriptorImpl descriptor) {
		this.descriptor = descriptor;
	}

	/**
	 * Retrieves the ratype descriptor
	 * @return
	 */
	public ResourceAdaptorTypeDescriptorImpl getDescriptor() {
		return descriptor;
	}

	/**
	 * Retrieves the ratype id
	 * @return
	 */
	public ResourceAdaptorTypeID getResourceAdaptorTypeID() {
		return descriptor.getResourceAdaptorTypeID();
	}

	/**
	 * Retrieves the aci factory concrete class, generated by SLEE
	 * @return
	 */
	public Class<?> getActivityContextInterfaceFactoryConcreteClass() {
		return activityContextInterfaceFactoryConcreteClass;
	}
	
	/**
	 * Retrieves the aci factory interface
	 * @return
	 */
	public Class<?> getActivityContextInterfaceFactoryInterface() {
		return activityContextInterfaceFactoryInterface;
	}
	
	/**
	 * Sets the aci factory concrete class, generated by SLEE
	 * @param activityContextInterfaceFactoryConcreteClass
	 */
	public void setActivityContextInterfaceFactoryConcreteClass(
			Class<?> activityContextInterfaceFactoryConcreteClass) {
		this.activityContextInterfaceFactoryConcreteClass = activityContextInterfaceFactoryConcreteClass;
	}
	
	/**
	 * Sets the aci factory interface
	 * @param activityContextInterfaceFactoryInterface
	 */
	public void setActivityContextInterfaceFactoryInterface(
			Class<?> activityContextInterfaceFactoryInterface) {
		this.activityContextInterfaceFactoryInterface = activityContextInterfaceFactoryInterface;
	}
	
	@Override
	public boolean addToDeployableUnit() {
		return getDeployableUnit().getResourceAdaptorTypeComponents().put(getResourceAdaptorTypeID(), this) == null;
	}
	
	@Override
	public Set<ComponentID> getDependenciesSet() {
		return descriptor.getDependenciesSet();
	}
	
	@Override
	public boolean isSlee11() {
		return descriptor.isSlee11();
	}
	
	@Override
	public ComponentID getComponentID() {
		return getResourceAdaptorTypeID();
	}
	
	@Override
	public boolean validate() throws DependencyException, DeploymentException {
		// FIXME use validator when available
		return true;
	}

	public Class<?> getResourceAdaptorSBBInterface() {
		return resourceAdaptorSBBInterface;
	}

	public void setResourceAdaptorSBBInterface(Class<?> resourceAdaptorSBBInterface) {
		this.resourceAdaptorSBBInterface = resourceAdaptorSBBInterface;
	}
	
	/**
	 * Retrieves the instance of the aci factory for this ra type
	 * @return
	 */
	public Object getActivityContextInterfaceFactory() {
		return activityContextInterfaceFactory;
	}
	
	/**
	 * Sets the instance of the aci factory for this ra type
	 * @param activityContextInterfaceFactory
	 */
	public void setActivityContextInterfaceFactory(
			Object activityContextInterfaceFactory) {
		this.activityContextInterfaceFactory = activityContextInterfaceFactory;
	}
	
	/**
	 *  Retrieves the JAIN SLEE specs descriptor
	 * @return
	 */
	public javax.slee.resource.ResourceAdaptorTypeDescriptor getSpecsDescriptor() {
		if (specsDescriptor == null) {
			final LibraryID[] libraryIDs = descriptor.getLibraryRefs().toArray(new LibraryID[descriptor.getLibraryRefs().size()]);
			final String[] activityTypes = descriptor.getActivityTypes().toArray(new String[descriptor.getActivityTypes().size()]);
			final EventTypeID[] eventTypes = descriptor.getEventTypeRefs().toArray(new EventTypeID[descriptor.getEventTypeRefs().size()]);
			String raInterface = descriptor.getResourceAdaptorInterface() == null ? null : descriptor.getResourceAdaptorInterface();
			specsDescriptor = new javax.slee.resource.ResourceAdaptorTypeDescriptor(getResourceAdaptorTypeID(),getDeployableUnit().getDeployableUnitID(),getDeploymentUnitSource(),libraryIDs,activityTypes,raInterface,eventTypes);
		}
		return specsDescriptor;
	}
	
	@Override
	public ComponentDescriptor getComponentDescriptor() {
		return getSpecsDescriptor();
	}
	@Override
	public void processSecurityPermissions() throws DeploymentException {
		//Do nothing?
		
	}
	
	@Override
	public void undeployed() {
		super.undeployed();
		specsDescriptor = null;
		activityContextInterfaceFactory = null;
		activityContextInterfaceFactoryConcreteClass = null;
		activityContextInterfaceFactoryInterface = null;
		resourceAdaptorSBBInterface = null;
	}
}
