package com.redhat.installer.postinstall;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import com.izforge.izpack.util.VariableSubstitutor;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandLineException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.postinstall.ServerCommands.BatchIsEmptyException;

/**
 * @author dcheung@redhat.com, dmondega@redhat.com, thauser@redhat.com
 */
public class PostInstallation {
    // the command context
    private static final String TIMEOUT  = "timeout";
    private static final String ATTEMPTS = "attempts";
    private static final String DEFAULT_TIMEOUT  = "3";
    private static final String DEFAULT_ATTEMPTS = "3";
    private static final String LOGFILE = "logfile";
    private static final String IncludeSSLAndLDAP = "IncludeSSLAndLDAP";
    private static final String XML_DESCRIPTOR = "xml-file";
    private static final String IS_DOMAIN = "is-domain";
    private static final String POST_LOG_PATH = "postinstall-logs";
    private static boolean writeLog = false;
	private static ServerCommands serverCommands;
	//private static String profile; // the server profile we will execute all of
									// the commands on
	private static boolean isDomain; // boolean to indicate domain-ness or not.
	private static String jbossHome; // location of the installation
	private static String username; // username for the management interface
									// (configured in installer)
	private static boolean isSecurityDomain; // if a security domain is
												// specified, we must indicate
												// this and not try to use
												// username/password
	private static char[] password; // password for the management interface
									// (configured in installer)

	private static String realm;   // Realm used for post-install.
	private static String path;    // Path to installation.

	private static AbstractUIProcessHandler mHandler; // output to the
														// processpanel
	private static AutomatedInstallData idata; // all of the install data
												// variables and the like
	private static ArgumentParser parser;

	// JDBC members
	private static boolean installJdbc;
	private static ArrayList<String> jarFiles; // file objects of said jars
	private static String jdbcName;
	private static String jdbcModuleName;
	private static String jdbcXaDsName;
	private static String jdbcDirStruct;

	// Datasource members
	private static boolean installDatasource;
	private static String dsName;
	private static String dsJndiName;
	private static boolean dsIsXa;
	private static String dsMinPool;
	private static String dsMaxPool;
	private static String dsUsername;
	private static String dsPassword;
	private static String dsXaRecoveryUser;
	private static String dsXaRecoveryPass;
	private static String dsSecurityDomain;
	private static String dsConnectionUrl;
	private static Map<String, String> dsXaProps;

	// ssl members
	private static boolean installSsl;
	private static String keystorePassword; // keystore password
	private static String keystore; // keystore location

	// ldap members
	private static boolean installLdap;
	private static String ldapName;
	private static String ldapUrl;
	private static String ldapDn;
	private static String ldapPwd;
	private static String ldapBaseDn;
	private static String ldapRecursive;
	private static String ldapRealmName;
	private static String ldapFilter;
	private static boolean ldapFilterType;

	// password vault members
	private static boolean installVault;
	private static String vaultKeystoreUrl;
	private static String vaultKeystorePwd;
	private static String vaultEncrDir;
	private static String vaultSalt;
	private static int vaultIterCount;
	private static String vaultAlias;
	private static boolean vaultPreExisting;

	// infinispan members
	private static boolean installInfinispan;
	private static String infinispanContainer;
	private static String infinispanJndi;
	private static String infinispanLocalCache;
	private static String infinispanTransMode;
	private static String infinispanEvictStrat;
	private static String infinispanEvictMaxEntries;
	private static String infinispanExpirationMax;

	// jms queue stuff
	private static boolean installJmsQueues;
	private static String jmsName;
	private static List<String> jmsEntries;
	private static boolean jmsDurable;
	private static List<String> jmsHeaders;
	private static String jmsSelector;

	// security domain stuff
	private static boolean installSecurityDomain;
	private static String secDomName;
	private static String secDomCache;
	private static String secDomAuthenCode;
	private static String secDomAuthenFlag;
	private static Map<String, String> secDomAuthenOpts;
	private static String secDomAuthorCode;
	private static String secDomAuthorFlag;
	private static Map<String, String> secDomAuthorOpts;
	private static String secDomMappingCode;
	private static String secDomMappingType;
	private static Map<String, String> secDomMappingOpts;
	private static Map<String, String> secDomJsseAttrs;
	private static Map<String, String> secDomJsseKeystoreAttrs;
	private static Map<String, String> secDomJsseKeystoreManagerAttrs;
	private static Map<String, String> secDomJsseTruststoreAttrs;
	private static Map<String, String> secDomJsseTruststoreManagerAttrs;
	private static Map<String, String> secDomJsseAdditionalProps;
	private static String xmlDescriptor;	

    // Vault members
    private static String vaultEncrDirSubbed = "";
    private static String vaultKeystoreUrlSubbed ="";

	// TODO: Overall: add a descriptor to the error messages, for example:
	// "InstallSsl: idata.langpack.getString('blah')" so the error messages
	// are more informative
	// TODO: parameterize everything, if possible. maybe call the methods from
	// other classes, and use that class based upon the installer we're
	// running? since they are all static methods anyways
	public static boolean run(AbstractUIProcessHandler handler, String[] args)
			throws Exception {
	    // Parse the xml spec file arguments.
        parser = new ArgumentParser();
        parser.parse(args);

		idata = AutomatedInstallData.getInstance();
		mHandler = handler;

		init();
		if (!parser.hasProperty(IncludeSSLAndLDAP)){
			installAll();
		} else {
			installAll(Boolean.parseBoolean(parser.getProperty(IncludeSSLAndLDAP)));
		}
	
		try {
			if (writeLog){
				serverCommands.writeLogFile();
				ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.log.success") + serverCommands.getLogFilePath(), false);
			}			
		} catch (Exception e){
			ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.log.error"), true);
		}
		
		// connect here instead
		try {
			connectContext(args);
			// if we get here with current design, we're connected 
		} catch (Exception e){
			e.printStackTrace();
		}

		try {
    		if (serverCommands.runBatch() != 0){
    			// here is where we report success or failure
    			ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.batch.error"), true);
    			return false;
    		} else{
    			ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.batch.success"), false);
    		}
		} catch (CommandLineException e) {
		    ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.batch.error"), true);
		    return false;
		} catch (BatchIsEmptyException e) {
		    ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.batch.empty"), false);
		}
		
		serverCommands.terminateSession();
		return true;
		// shutdownHost();
        // ServerCommandsHelper.removePostInstallUser();
        // Runs in its own process now no longer needed.
	}

	private static void installAll(boolean includeSSLAndLDAP) {
		if (installVault) {
			if (!includeSSLAndLDAP) {
			installVault();
		}
		}

		if (installSsl) {
			if (includeSSLAndLDAP) {
			installSsl();
		}
		}

		if (installLdap) {
			if (includeSSLAndLDAP) {
			installLdap();
		}
		}

		if (installInfinispan) {
			if (!includeSSLAndLDAP) {
			installInfinispan();
		}
		}

		if (installJmsQueues) { 
			if (!includeSSLAndLDAP) {
			installJmsQueues();
		}
		}
		if (installSecurityDomain) {
			if (!includeSSLAndLDAP) {
			installSecurityDomain();
		}
		}

		if (installJdbc) {
			if (!includeSSLAndLDAP) {
			createJdbcFiles();
			createJDBCModuleXml();
			installJdbcDriver();
		}
		}
		
		if (installDatasource){
			if (!includeSSLAndLDAP) {
			installDatasource();
            }
		}
		
		try {
			if (writeLog){
				serverCommands.writeLogFile();
				mHandler.logOutput(idata.langpack.getString("postinstall.processpanel.log.success") + serverCommands.getLogFilePath(), false);
		    }
		} catch (Exception e){
			mHandler.logOutput(idata.langpack.getString("postinstall.processpanel.log.error"), true);
		}
    }
		
	private static void installAll() {
		if (installVault) {
			installVault();
		}

		if (installSsl) {
			installSsl();
    	}
		
		if (installLdap) {
			installLdap();
		}
		
		if (installInfinispan) {
			installInfinispan();
		}

		if (installJmsQueues) { 
			installJmsQueues();
		}
		
		if (installSecurityDomain) {
			installSecurityDomain();
		}

		if (installJdbc) {
			createJdbcFiles();
			createJDBCModuleXml();
			installJdbcDriver();
		}
		
		if (installDatasource){
			installDatasource();
		}	
	}

	private static void init() {
		jbossHome = idata.getInstallPath() + File.separator + idata.getVariable("INSTALL_SUBPATH") + File.separator;
		writeLog = parser.hasProperty(LOGFILE);
		String logName = null;
		if (writeLog){
			logName = parser.getProperty(LOGFILE);
		}
		
		xmlDescriptor = parser.getProperty(XML_DESCRIPTOR);
		
		// init the command context using post-install usr and pwd.
        username = idata.getVariable(PostInstallUserHelper.USERNAME_VAR);
        password = idata.getVariable(PostInstallUserHelper.PWD_VAR)
                .toCharArray();
        realm = idata.getVariable(PostInstallUserHelper.REALM_VAR);
        path = idata.getVariable(PostInstallUserHelper.PATH_VAR);

		// for which profile
		//isDomain = idata.getVariable("postinstall.profile").equals("domain");
        isDomain = parser.getProperty(IS_DOMAIN) != null ? true : false;

        /***
         * ServerManager figures out all of the important details about the
         * currently running server, and returns the correct port...in theory.
         */
        int managementPort = ServerManager.getManagementPort();
		serverCommands = null;
		
		try {
			
			if (isDomain) {
				serverCommands = ServerCommands.createLocalDomainUsernameSession(username, password, managementPort, new String[]{"default","ha","full","full-ha"});
			} else {
				serverCommands = ServerCommands.createLocalStandaloneUsernameSession(username, password, managementPort);
			}
			
		} catch (CliInitializationException e) { // shouldn't happen if our params are good. if it does happen, it's an initialization failure
			ProcessPanelHelper.printToPanel(mHandler,idata.langpack.getString("postinstall.processpanel.init.error"), true);
		}

        serverCommands.setContextLoggingConfig(idata.getVariable("INSTALL_PATH") + "/jboss-eap-6.1/bin/jboss-cli-logging.properties");
        if (writeLog){
        	serverCommands.setLogFilePath(idata.getVariable("INSTALL_PATH") + "/" + idata.getVariable("INSTALL_SUBPATH") + "/" + POST_LOG_PATH + "/" +logName);
        }
        serverCommands.createNewBatch(); // we need batch mode for our purposes

		// which options are we configuring?
		
		String ssl = idata.getVariable("installSsl");
		String ldap = idata.getVariable("installLdap");
		String vault = idata.getVariable("installVault");
		String infinispan = idata.getVariable("installInfinispan");
		String securityDomain = idata.getVariable("installSecurityDomain");
		String jdbc = idata.getVariable("jdbc.driver.install");
		String datasource = idata.getVariable("datasource.install");


        /**
         * Vault is installed any time any fsw  pack is being installed or
         * if user chose vault post install option.
         */
        // idata.getRules().isConditionTrue("dv.install") <- DV has no default vault
        PostInstallation.installVault = (idata.getRules().isConditionTrue("fsw.install") ||
                idata.getRules().isConditionTrue("sramp-dt-gov.install") ||
                idata.getRules().isConditionTrue("sramp.install") ||
                idata.getRules().isConditionTrue("rt.client.install") ||
                idata.getRules().isConditionTrue("rt.server.install") ||
                ((vault != null) && (vault.equals("on"))));

		// null checks required for different installer requirements
		if (ssl != null){
			PostInstallation.installSsl = ssl.equals("on");
		}
		
		if (ldap != null){
			PostInstallation.installLdap = ldap.equals("on");
		}
        if (infinispan != null){
			PostInstallation.installInfinispan= infinispan.equals("on");
		}
		if (securityDomain != null){
			PostInstallation.installSecurityDomain = securityDomain.equals("on");
		}
		if (jdbc != null){
			PostInstallation.installJdbc= jdbc.equals("on");
		}
		
		if (datasource != null){
			PostInstallation.installDatasource= datasource.equals("on");
		}
		// installJmsQueues = idata.getVariable("installJmsQueue").equals("on")
		// ? true : false;

		if (installVault) {
			initVault();
		}

		if (installJdbc) {
			initJdbc();
		}

		if (installSsl) {
			initSsl();
		}

		if (installLdap) {
			initLdap();
		}

		if (installInfinispan) {
			initInfinispan();
		}

		/*
		 * if (installJmsQueues){ initJmsQueues(); }
		 */

		if (installSecurityDomain) {
			initSecurityDomain();
		}
	}
	
	/**
	 * Connect the context
	 * @throws InterruptedException 
	 */

	private static void connectContext(String [] args) throws InterruptedException {
        int timeToSleep  = Integer.parseInt(parser.getProperty(TIMEOUT, DEFAULT_TIMEOUT));
        int attemptLimit = Integer.parseInt(parser.getProperty(ATTEMPTS, DEFAULT_ATTEMPTS));

		int attempts = 0; // Number of attempts to connect to management interface.
	    String connectSuccess = idata.langpack.getString("postinstall.processpanel.management.connectSuccess");
	    String connectFail = idata.langpack.getString("postinstall.processpanel.management.connectFail");
	    String connectAttempt = idata.langpack.getString("postinstall.processpanel.management.connecting");
/*		if (idata.getVariable(SERVER_UP).equals("false")) {
		    return;
		}*/
	    
	    // Attempt to connect to the management interface.
		while (attempts < attemptLimit) {
			ProcessPanelHelper.printToPanel(mHandler,String.format(connectAttempt, attempts + 1, attemptLimit), false);
			try {
				// sleep first, to give the server some time
				Thread.sleep(timeToSleep * 1000);
				serverCommands.connectContext();
			} catch (CommandLineException e) {
				// We did not successfully connect, so try again after waiting,
				// but only
				// if we have attempts left.
				attempts++;
				if (attempts >= attemptLimit) {
					ProcessPanelHelper.printToPanel(mHandler,String.format(connectFail, attempts), false);
					// e.printStackTrace();
					return;
				}
				continue;
			}
			// If there is no exception, we've connected to the management
			// interface.
			ProcessPanelHelper.printToPanel(mHandler,connectSuccess, false);
			// TODO: paramaterize the /jboss-eap-6.1/bin/ part of the location
			// of the jboss-cli-logging.properties.
			// We have successfully connected to the management interface.
			break;
		}
	}

	/**
	 * 
	 * 
	 * 
	 * Begin init methods. Gathers information from IzPack idata object and puts it into variables.
	 * 
	 * 
	 * 
	 */
	private static void initVault() {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        String keystoreUrl = idata.getVariable("vault.keystoreloc");
        String encrDir = idata.getVariable("vault.encrdir");
        String iterCount = idata.getVariable("vault.itercount");
        String alias = idata.getVariable("vault.alias");

		vaultKeystoreUrl = (keystoreUrl != null)? vs.substitute(keystoreUrl) : vs.substitute(idata.getVariable("vault.keystoreloc.default"));
		vaultKeystorePwd = idata.getVariable("vault.keystorepwd");
		vaultEncrDir = (encrDir != null) ? vs.substitute(encrDir) : vs.substitute(idata.getVariable("vault.encrdir.default"));
        vaultSalt = idata.getVariable("vault.salt");
        vaultIterCount = (iterCount != null) ? Integer.parseInt(iterCount) : Integer.parseInt(idata.getVariable("vault.itercount.default"));
        vaultAlias = (alias != null) ? alias : idata.getVariable("vault.alias.default");

		// the salt must be processed in the GUI / console to be == 8 digits
		// long. we will NOT check it here, because we can't abide failure at
		// this stage

		String preExist = idata.getVariable(xmlDescriptor+".vault.preexisting");
		if (preExist != null){
			vaultPreExisting = Boolean.parseBoolean(preExist);
		} else {
			vaultPreExisting = false;
		}
		if (!vaultEncrDir.endsWith(File.separator)) {
			vaultEncrDir += File.separator;
		}

		// create a vault session with the information we gathered
		try {
			serverCommands.createVaultSession(vaultKeystoreUrl,
					vaultKeystorePwd, vaultEncrDir, vaultSalt, vaultIterCount,
					vaultAlias);
		} catch (Throwable e) {
			ProcessPanelHelper.printToPanel(mHandler,
					idata.langpack.getString("Vault creation failed!"), true);
			e.printStackTrace();
		}

        /**
         * Substitute jboss home vars if they are referenced in the vault paths:
         */
        String configDir = idata.getVariable("jboss.server.config.dir");
        String homeDir = idata.getVariable("jboss.home.dir");
        String defaultKeystoreUrl = vs.substitute(idata.getVariable("vault.keystoreloc.default"));
        String defaultEncrDir = vs.substitute(idata.getVariable("vault.encrdir.default"));

        if (defaultKeystoreUrl != null) {
            if (vaultKeystoreUrl.equals(defaultKeystoreUrl)) {
                vaultKeystoreUrlSubbed = "${jboss.server.config.dir}/vault.keystore";
            } else {
                if (configDir != null) {
                    vaultKeystoreUrl = vaultKeystoreUrl.replace(configDir, "${jboss.server.config.dir}");
                }

                if (homeDir != null) {
                    vaultKeystoreUrl = vaultKeystoreUrl.replace(homeDir, "${jboss.home.dir}");
                }
                vaultKeystoreUrlSubbed = vaultKeystoreUrl;
            }
        }

        if (defaultEncrDir != null) {
            if (vaultEncrDir.equals(defaultEncrDir)) {
                vaultEncrDirSubbed = "${jboss.home.dir}/vault";
            } else {
                if (configDir != null) {
                    vaultEncrDir = vaultEncrDir.replace(configDir, "${jboss.server.config.dir}");
                }

                if (homeDir != null) {
                    vaultEncrDir = vaultEncrDir.replace(homeDir, "${jboss.home.dir}");
                }
                vaultEncrDirSubbed = vaultEncrDir;
            }
        }
    }

	private static void initSsl() {
		keystore = idata.getVariable("ssl.path");
		keystorePassword = idata.getVariable("ssl.password");
	}

	private static void initLdap() {
		ldapName = idata.getVariable("ldap.name");
		ldapUrl = idata.getVariable("ldap.url");
		ldapDn = idata.getVariable("ldap.dn");
		ldapPwd = idata.getVariable("ldap.creds");
		ldapRealmName = idata.getVariable("ldap.realmname");
		ldapBaseDn = idata.getVariable("ldap.basedn");
		ldapRecursive = idata.getVariable("ldap.recursive");
		ldapFilterType = idata.getVariable("ldap.filtertype")
				.equals("advanced");
		ldapFilter = idata.getVariable("ldap.filter");
	}

	private static void initJdbc() {
		
		int counter = 1; // counter starts at one due to DynamicComponentsPanel design
		jarFiles = new ArrayList<String>();
		while (true) {
			String path = idata.getVariable("jdbc.driver.jar-"
					+ counter + "-path");
			if (path != null) {
				jarFiles.add(path);
				counter++;
			} else {
				// no more. we're done.
				break;
			}
		}
		jdbcName = idata.getVariable("jdbc.driver.name");
		jdbcModuleName = idata.getVariable("jdbc.driver.module.name");
		jdbcXaDsName = idata.getVariable("jdbc.driver.xads.name");
		jdbcDirStruct = idata.getVariable("jdbc.driver.dir.struct");

		// datasource variables
		dsName = idata.getVariable("jdbc.datasource.name");
		dsJndiName = idata.getVariable("jdbc.datasource.jndiname");
        dsIsXa = (idata.getVariable("jdbc.datasource.datasourcetype") != null && idata
                .getVariable("jdbc.datasource.datasourcetype").equals("true"));
		dsMinPool = idata.getVariable("jdbc.datasource.minpoolsize");
		dsMaxPool = idata.getVariable("jdbc.datasource.maxpoolsize");
		dsConnectionUrl = idata.getVariable("jdbc.datasource.connectionurl");
		// pack the xa props map
		dsXaProps = new HashMap<String, String>();
		dsXaProps.put("ServerName",
				idata.getVariable("jdbc.datasource.xa.servername"));
		dsXaProps.put("DatabaseName",
				idata.getVariable("jdbc.datasource.xa.databasename"));
		dsXaProps.put("PortNumber",
				idata.getVariable("jdbc.datasource.xa.portnumber"));
		dsXaProps.put("URL", idata.getVariable("jdbc.datasource.xa.oracleurl"));
		dsXaProps.put("NetworkProtocol",
				idata.getVariable("jdbc.datasource.xa.sybaseprotocol"));
		dsXaProps.put("SelectMethod",
				idata.getVariable("jdbc.datasource.xa.microsoftcursor"));

		counter = 1; // reset counter for the next dynamicPanel
		while (true) {
			String prop = idata.getVariable("jdbc.datasource.xa.extraprops-"
					+ counter + "-name");
			if (prop != null) {
				dsXaProps.put(
						prop,
						idata.getVariable("jdbc.datasource.xa.extraprops-"
								+ counter + "-value"));
				counter++;
			} else {
				// no more. we're done.
				break;
			}
		}

		dsUsername = idata.getVariable("jdbc.datasource.username");
		dsPassword = idata.getVariable("jdbc.datasource.password");
		dsXaRecoveryUser = idata.getVariable("jdbc.datasource.xa.recoveryuser");
		dsXaRecoveryPass = idata.getVariable("jdbc.datasource.xa.recoverypass");

        dsSecurityDomain = idata
                .getVariable("jdbc.datasource.securitydomain");

        /**
         * We are using security domain only if this variable is neither null
         * nor an empty string. That is, if it holds a real string value.
         */
        isSecurityDomain = (dsSecurityDomain != null && !dsSecurityDomain
                .equals(""));
	}

	private static void initInfinispan() {
		infinispanContainer = idata.getVariable("infinispan.container");
		infinispanJndi = idata.getVariable("infinispan.jndiname");
		infinispanLocalCache = idata.getVariable("infinispan.localcache");
		infinispanTransMode = idata.getVariable("infinispan.transactionmode");
		infinispanEvictStrat = idata.getVariable("infinispan.evictionstrat");
		infinispanEvictMaxEntries = idata.getVariable("infinispan.evictionmax");
		infinispanExpirationMax = idata.getVariable("infinispan.expirationmax");
	}

	private static void initJmsQueues() {
		jmsName = idata.getVariable("jmsqueue.name");
		jmsEntries = new ArrayList<String>();
		String[] tmpEntry = idata.getVariable("jmsqueue.entries").split(",");
		for (String e : tmpEntry) {
			jmsEntries.add(e);
		}
		jmsDurable = idata.getVariable("jmsqueue.durable").equals("true");
		jmsHeaders = null; // TODO: add this in when implemented
	}

	private static void initSecurityDomain() {
		secDomName = idata.getVariable("securitydomain.name");
		secDomCache = idata.getVariable("securitydomain.cachetype");
		secDomAuthenCode = idata.getVariable("securitydomain.authencode");
		secDomAuthenFlag = idata.getVariable("securitydomain.authenflag");
		secDomAuthenOpts = new HashMap<String, String>();

		// TODO: make this cleaner. easy to break as well
		String authenOpt = idata.getVariable("securitydomain.authenopts");
		if (authenOpt != null) {
			String[] authenOpts = authenOpt.split(",");
			for (String opt : authenOpts) {
				String[] option = opt.split("=");
				secDomAuthenOpts.put(option[0], option[1]); // TODO: fix this
															// parsing
			}
		}

		secDomAuthorCode = idata.getVariable("securitydomain.authorcode");
		secDomAuthorFlag = idata.getVariable("securitydomain.authorflag");
		secDomAuthorOpts = new HashMap<String, String>(1);

		String authorOpt = idata.getVariable("securitydomain.authoropts");
		if (authorOpt != null) {
			String[] authorOpts = authorOpt.split(",");
			for (String opt : authorOpts) {
				String[] option = opt.split("=");
				secDomAuthorOpts.put(option[0], option[1]); // hacky, but good
															// enough for now
			}
		}

		secDomMappingCode = idata.getVariable("securitydomain.mappingcode");
		secDomMappingType = idata.getVariable("securitydomain.mappingtype");
		secDomMappingOpts = new HashMap<String, String>(1);

		String mappingOpt = idata.getVariable("securitydomain.mappingopts");
		if (mappingOpt != null) {
			String[] mappingOpts = mappingOpt.split(",");
			for (String opt : mappingOpts) {
				String[] option = opt.split("=");
				secDomMappingOpts.put(option[0], option[1]); // hacky, but good
																// enough for
																// now
			}
		}
		// create these only if an attribute within them exists

		secDomJsseAttrs = secDomJsseKeystoreAttrs = secDomJsseKeystoreManagerAttrs = secDomJsseTruststoreAttrs = secDomJsseTruststoreManagerAttrs = secDomJsseAdditionalProps = null;
		
		String ciphersuites = idata.getVariable("securitydomain.jsse.ciphersuites");
		String protocols = idata.getVariable("securitydomain.jsse.protocols");
        String clientalias = idata
                .getVariable("securitydomain.jsse.client-alias");
        String serveralias = idata
                .getVariable("securitydomain.jsse.server-alias");
		String authtoken = idata.getVariable("securitydomain.jsse.authtoken");
		
		if (ciphersuites != null || protocols != null || clientalias != null || serveralias != null || authtoken != null){
			secDomJsseAttrs = new HashMap<String, String>();
			secDomJsseAttrs.put("cipher-suites", ciphersuites);
			secDomJsseAttrs.put("protocols", protocols);
            secDomJsseAttrs.put("client-alias", clientalias);
            secDomJsseAttrs.put("server-alias", serveralias);
			secDomJsseAttrs.put("service-auth-token",authtoken);
		}
		
		// if this is null, we can safely ignore the others as well, since this is required.
		String keystorePwd = idata.getVariable("securitydomain.jsse.keystore.password");
		
		if (keystorePwd != null){
			secDomJsseKeystoreAttrs = new HashMap<String,String>();
			secDomJsseKeystoreAttrs.put("password",keystorePwd);
			secDomJsseKeystoreAttrs.put("provider",idata.getVariable("securitydomain.jsse.keystore.provider"));
			secDomJsseKeystoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.keystore.providerargument"));
			secDomJsseKeystoreAttrs.put("type", idata.getVariable("securitydomain.jsse.keystore.type"));
			secDomJsseKeystoreAttrs.put("url",idata.getVariable("securitydomain.jsse.keystore.url"));
		}
		
		String keystoreManagerAlgo = idata.getVariable("securitydomain.jsse.keystoremanager.algorithm");
		String keystoreManagerProvider = idata.getVariable("securitydomain.jsse.keystoremanager.provider");
		
		if (keystoreManagerAlgo != null || keystoreManagerProvider != null){
			secDomJsseKeystoreManagerAttrs = new HashMap<String,String>();
			secDomJsseKeystoreManagerAttrs.put("algorithm",keystoreManagerAlgo);
			secDomJsseKeystoreManagerAttrs.put("provider",keystoreManagerProvider);
		}
		
		// same deal as keystorePwd
		String truststorePwd = idata.getVariable("securitydomain.jsse.truststore.password");
		
		if (truststorePwd != null){
			secDomJsseTruststoreAttrs = new HashMap<String,String>();
			secDomJsseTruststoreAttrs.put("password",truststorePwd);
			secDomJsseTruststoreAttrs.put("provider",idata.getVariable("securitydomain.jsse.truststore.provider"));
			secDomJsseTruststoreAttrs.put("provider-argument", idata.getVariable("securitydomain.jsse.truststore.providerargument"));
			secDomJsseTruststoreAttrs.put("type", idata.getVariable("securitydomain.jsse.truststore.type"));
			secDomJsseTruststoreAttrs.put("url",idata.getVariable("securitydomain.jsse.truststore.url"));
		}
		
		String truststoreManagerAlgo = idata.getVariable("securitydomain.jsse.truststoremanager.algorithm");
		String truststoreManagerProvider = idata.getVariable("securitydomain.jsse.truststoremanager.provider");
		
		if (truststoreManagerAlgo != null || truststoreManagerProvider != null){
			secDomJsseTruststoreManagerAttrs = new HashMap<String,String>();
			secDomJsseTruststoreManagerAttrs.put("algorithm",truststoreManagerAlgo);
			secDomJsseTruststoreManagerAttrs.put("provider", truststoreManagerProvider);
		}
	}

	/*********************************************************************************************************************
	 * 
	 * 
	 * Begin install methods
	 * 
	 * 
	 *********************************************************************************************************************/

	/**
	 * This method simply tells thje serverCommands instance to install the Vault
	 * onto the server it is currently connected to, using the details
	 * previously supplied by calling serverCommands.createVaultSession
	 */
	private static void installVault() {
/*		if (serverCommands.installVault() != 0) {
			mHandler.logOutput(idata.langpack
					.getString("postinstall.processpanel.vault.error"), true);
		} else {
			mHandler.logOutput(idata.langpack
					.getString("postinstall.processpanel.vault.success"), true);
			// successful install, we take all the passwords and replace them
			// with the value in the vault
		*/
		// Since we are in batch mode, the commands all fail, or they all succeed
		if (!vaultPreExisting){
            if (!vaultKeystoreUrlSubbed.isEmpty() && !vaultEncrDirSubbed.isEmpty()){
			    serverCommands.installVault(vaultKeystoreUrlSubbed,vaultEncrDirSubbed);
            } else {
                serverCommands.installVault();
            }
		}
		
		
	//	}
	}

	private static void createJdbcFiles() {
		// TODO: maybe return a list of files copied from createModuleFiles
		try {
			serverCommands
					.createModuleFiles(jarFiles, jbossHome, jdbcDirStruct);
		} catch (Throwable e) {
			ProcessPanelHelper.printToPanel(mHandler,idata.langpack
					.getString("postinstall.processpanel.jarcopy.error"), true);
			ProcessPanelHelper.printToPanel(mHandler,e.getMessage(), true);
		}
		ProcessPanelHelper.printToPanel(mHandler,idata.langpack
				.getString("postinstall.processpanel.jarcopy.success"), false);
	}

	/**
	 * Creates a JDBC module xml using serverCommands. The serverCommands method
	 * can be used to create a module.xml anywhere.
	 */
	private static void createJDBCModuleXml() {
		String modulePath = jbossHome + jdbcDirStruct + File.separator
				+ "module.xml";
		List<String> deps = new ArrayList<String>();
		deps.add("javax.api");
		deps.add("javax.transaction.api");
		
		List<String> resourceNames = new ArrayList<String>(); 

		for (String jar : jarFiles){
			File test = new File(jar);
			resourceNames.add(test.getName());
		}
		
		try {
			serverCommands.createModuleXml(jbossHome, jdbcDirStruct,
					jdbcModuleName, resourceNames, deps);
		} catch (ParserConfigurationException e) {
			ProcessPanelHelper.printToPanel(mHandler,
					idata.langpack
							.getString("postinstall.processpanel.xmlcreation.error")
							+ modulePath, true);
		} catch (TransformerException e) {
			ProcessPanelHelper.printToPanel(mHandler,
					idata.langpack
							.getString("postinstall.processpanel.xmlcreation.error")
							+ modulePath, true);
		} catch (IOException e) {
			ProcessPanelHelper.printToPanel(mHandler,
					idata.langpack
							.getString("postinstall.processpanel.xmlcreation.error")
							+ modulePath, true);
		}
	}

	/**
	 * Passes the gathered IncludeSSLAndLDAP information (keystore location and password) to
	 * serverCommands. ServerCommands adds the IncludeSSLAndLDAP configuration to the
	 * descriptor
	 */
	private static void installSsl() {
		serverCommands.installSsl(keystore, keystorePassword);
	}

	/**
	 * Installs a JDBC driver with the gathered information onto the AS
	 */
	private static void installJdbcDriver() {
		serverCommands.installJdbcDriver(jdbcName, jdbcModuleName, jdbcXaDsName);
	}

	// TODO: look into this again: is-same-rm-override element DB2 needs this too. So does Microsoft SQL

	private static void installDatasource() {
		if (dsIsXa) { // XA command!
			if (isSecurityDomain) {
				serverCommands.installXaDatasourceSecurityDomain(dsName,
						dsJndiName, jdbcName, dsMinPool, dsMaxPool,
						dsSecurityDomain, dsXaProps, dsXaRecoveryUser,
						dsXaRecoveryPass);
			} else {
				serverCommands.installXaDatasourceUsernamePwd(dsName,
						dsJndiName, jdbcName, dsMinPool, dsMaxPool, dsUsername,
						dsPassword, dsXaProps, dsXaRecoveryUser,
						dsXaRecoveryPass);
			}
		} else {
			if (isSecurityDomain) {
				serverCommands.installDatasourceSecurityDomain(dsName,
						dsJndiName, jdbcName, dsConnectionUrl, dsMinPool,
						dsMaxPool, dsSecurityDomain);
			} else {
				serverCommands.installDatasourceUsernamePwd(dsName, dsJndiName,
						jdbcName, dsConnectionUrl, dsMinPool, dsMaxPool,
						dsUsername, dsPassword);
			}
		}
	}

	private static void installLdap() {
		serverCommands.installLdap(ldapName, ldapPwd, ldapUrl, ldapDn,
				ldapRealmName, ldapBaseDn, ldapFilter, ldapRecursive,
				ldapFilterType);
	}

	private static void installInfinispan() {
		serverCommands.addInfinispanCache(infinispanContainer,
				infinispanJndi, infinispanLocalCache, infinispanTransMode,
				infinispanEvictStrat, infinispanEvictMaxEntries,
				infinispanExpirationMax);
	}

	private static void installJmsQueues() {
		// TODO: correctly define the jmsHeaders and jmsSelector fields, instead
		// of just passing null.
/*		if (serverCommands.addJmsQueue(jmsName, jmsEntries, jmsDurable, null,
				null) != 0) {
			mHandler.logOutput(
					idata.langpack
							.getString("postinstall.processpanel.jmsqueues.install.error"),
					true);
		} else {
			mHandler.logOutput(
					idata.langpack
							.getString("postinstall.processpanel.jmsqueues.install.success"),
					true);
		}*/
		serverCommands.addJmsQueue(jmsName, jmsEntries, jmsDurable, null,
				null);
	}

	private static void installSecurityDomain() {
		/*
		 * int ret = serverCommands.addSecurityDomain(secDomName, secDomCache,
		 * secDomAuthenCode, secDomAuthenFlag, secDomAuthenOpts,
		 * secDomAuthorCode, secDomAuthorFlag, secDomAuthorOpts,
		 * secDomMappingCode, secDomMappingType, secDomMappingOpts); if (ret !=
		 * 0) { mHandler.logOutput( "Failed with " + ret + ": " + idata.langpack
		 * .getString("postinstall.processpanel.securitydomain.install.error"),
		 * true); } else { mHandler.logOutput( idata.langpack
		 * .getString("postinstall.processpanel.securitydomain.install.success"
		 * ), true); }
		 */
		// dirty. avoidable? 
		serverCommands.addSecurityDomain(secDomName, secDomCache, secDomAuthenCode, secDomAuthenFlag, secDomAuthenOpts, secDomAuthorCode, secDomAuthorFlag, secDomAuthorOpts, secDomMappingCode,
				secDomMappingType, secDomMappingOpts, secDomJsseAttrs, secDomJsseKeystoreAttrs, secDomJsseKeystoreManagerAttrs, secDomJsseTruststoreAttrs, secDomJsseTruststoreManagerAttrs,
				secDomJsseAdditionalProps);
		/*
		 * serverCommands.addSecurityDomain(secDomName, secDomCache,
		 * secDomAuthenCode, secDomAuthenFlag, secDomAuthenOpts,
		 * secDomAuthorCode, secDomAuthorFlag, secDomAuthorOpts,
		 * secDomMappingCode, secDomMappingType, secDomMappingOpts);
		 */
	}

	/********************************************************************************************************************
	 * 
	 * 
	 * End install methods
	 * 
	 * 
	 ********************************************************************************************************************/
	
	private static void shutdownHost() {
		// this command is submitted after the batch has ended. Thus, it needs its own error reporting
		if (serverCommands.shutdownHost() != 0) {
			ProcessPanelHelper.printToPanel(mHandler,idata.langpack
					.getString("postinstall.processpanel.shutdown.error"), true);
		} else {
			ProcessPanelHelper.printToPanel(mHandler,idata.langpack
					.getString("postinstall.processpanel.shutdown.success"),
					true);
		}
	}
}
