package com.redhat.installer.postinstall;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * A more general purpose script launcher that borrows from ProcessPanelHelper
 * @author dcheung@redhat.com, dmondega@redhat.com
 */
public class ScriptLauncherHelper {
    private static final String URL     = "link";
    private static final String SERVER_SCRIPT  = "server-script";
    private static final String TIMEOUT  = "timeout";
    private static final String ATTEMPTS = "attempts";

    private static final String DEFAULT_TIMEOUT  = "5";
    private static final String DEFAULT_ATTEMPTS = "10";
    private static final String DEFAULT_URL      = "http://localhost:8080";
    private static AbstractUIProcessHandler mHandler;

    public static void run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        ScriptLauncher script;
        LaunchBrowser br;
        String serverLocation   = null;
        String link             = null;
        String linkLocation     = null;
        mHandler = handler;
        int timeToSleep;
        int attempts;
        int attemptLimit;

      /*  if (args.length < 1 || args.length > 4) {
            mHandler.logOutput("Error: Usage:", true);
            mHandler.logOutput("\t java ScriptLauncher \\ ", true);
            mHandler.logOutput("\t --link=http://localhost \\ ", true);
            mHandler.logOutput("\t --server-script=path/to/script \\ ", true);
            mHandler.logOutput("\t --timeout=5 \t [Default:5] \\ ", true);
            mHandler.logOutput("\t --attempts=10 \t [Default:10]", true);
            mHandler.logOutput("", true);
            mHandler.logOutput("If server-script is not provided, then the program assumes that you don't want to start the server", true);
            mHandler.logOutput("If the link option is not specified, the link http://localhost will be used to test if the server started", true);
            mHandler.logOutput("Note that you need to provide a value for the link option in order to launch the browser", true);
            return;
        }*/

        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);

        timeToSleep  = Integer.parseInt(parser.getProperty(TIMEOUT, DEFAULT_TIMEOUT));
        attemptLimit = Integer.parseInt(parser.getProperty(ATTEMPTS, DEFAULT_ATTEMPTS));

        link = parser.getProperty(URL, DEFAULT_URL);

        if ((serverLocation = parser.getProperty(SERVER_SCRIPT)) != null) {
            script = new ScriptLauncher(serverLocation);
            mHandler.logOutput("Starting server", false);
            script.runScript();
            attempts    = 0;
            mHandler.logOutput("", false);
            mHandler.logOutput("Checking if server is up", false);
            while(!LinkAlive.isLinkAlive(link)) {
                attempts++;
                Thread.sleep(timeToSleep * 1000);
                if(attempts > attemptLimit) {
                    mHandler.logOutput("Server has not started after " + attemptLimit, true);
                    return;
                }
            }
            mHandler.logOutput("Server started successfully", false);
        } else { 
            // not server script; execute as a normal script
	    script = new ScriptLauncher(args);
            script.runScript();
        }

        // Note: the only difference between linkLocation and link is that
        // link takes a default value if the link option has no value
        // only do this if we're doing a server-script invocation
        if ((parser.getProperty(SERVER_SCRIPT)!= null) && LinkAlive.isLinkAlive(link) && ((linkLocation = parser.getProperty(URL)) != null)) {
            br = new LaunchBrowser();
            br.exec(linkLocation);
        }
    }

    /**
     * ArgumentParser parses arguments of the following format:
     *      --key=value
     *
     * Anything else will be ignored
     */
    private static class ArgumentParser {
        private static final String ARGS_OPTION = "--";
        private static final String EQUAL_SIGN = "=";
        private static final int ARGS_OPTION_LENGTH = ARGS_OPTION.length();
        private Properties property;

        {
            property = new Properties();
        }
        private void parse(final String[] args) {
            try {
                for (String argument: args) {
                    if (argument.startsWith(ARGS_OPTION) && argument.contains(EQUAL_SIGN)) {
                        // Escape the forward slash. Needed for load method to work properly
                        property.load(new StringReader(argument.substring(ARGS_OPTION_LENGTH).replaceAll("\\\\", "\\\\\\\\")));
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        private String getProperty(final String key) {
            return property.getProperty(key);
        }
        private String getProperty(final String key, final String defaultValue) {
            return property.getProperty(key, defaultValue);
        }
    }
    private static class LaunchBrowser {

        private Desktop desktop;

        private boolean createDesktopObject() {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                return true;
            } else {
                mHandler.logOutput("Cannot Open Browser!", true);
                return false;
            }
        }
        private void openURL(final String url) {
            try {
                desktop.browse(new URI(url));
            } catch (IOException e) {
                mHandler.logOutput("Cannot find default browser!", true);
            } catch (Exception f) {
                f.printStackTrace();
            }
        }
        private void exec(final String url) {
            if (createDesktopObject()) {
                openURL(url);
            }
        }
    }
    private static class ScriptLauncher {

        private ProcessBuilder builder;
        private Process p;
        private BufferedReader reader;
        private BufferedWriter writer;
        private String line;

        private ScriptLauncher(String... command) {
            builder = new ProcessBuilder(command);
        }

        @SuppressWarnings("deprecation")
        private void runScript() {
            try {
                p       = builder.start();
                reader  = new BufferedReader (new InputStreamReader(p.getInputStream()));
                writer  = new BufferedWriter (new OutputStreamWriter(p.getOutputStream()));
                writer.newLine();
                writer.flush();
                Thread b = new Thread(new Runnable() {
                    public void run() {
                        try {
                            while((line = reader.readLine()) != null) {
                                mHandler.logOutput(line, false);
                            }
                        } catch (IOException e) {
                        }
                    }
                });
                b.start();
                b.join(5000);
                b.stop();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class LinkAlive {
        public static boolean isLinkAlive(String URLName){
            try {
                HttpURLConnection.setFollowRedirects(false);
                HttpURLConnection con =
                    (HttpURLConnection) new URL(URLName).openConnection();
                con.setRequestMethod("HEAD");
                return (con.getResponseCode() == HttpURLConnection.HTTP_OK);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

}
