package com.redhat.installer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import com.izforge.izpack.installer.AutomatedInstallData;

/**
 * This validator will attempt to use the given JDBC driver jar to connect to the database the user has specified.
 * If the jar containing the remote class is a remote path, it will simply return true and trust the user. 
 * @author thauser
 * TODO: Squelch all of the exceptions
 * 
 *
 */
public class JDBCConnectionUtils {
	
	
	public static URL[] convertToUrlArray(Object[] jars) {
		URL[] jarUrls = new URL[jars.length];
		for (int i = 0; i < jarUrls.length; i++){
			try {
					String jar = (String) jars[i];
					
					if (!jar.startsWith("ftp://") && !jar.startsWith("http://")){
						// local jar
						jarUrls[i] = new File(jar).toURI().toURL();	
					} else {
						// remote jar
						jarUrls[i] = new URI(jar).toURL();
					}
				//System.out.println("URL added:" + jarUrls[i].toString());
			} catch (MalformedURLException e) {
				//e.printStackTrace();
			} catch (URISyntaxException e) {
				//e.printStackTrace();
			}
		}
		return jarUrls;
	}

	public static Object getDatabaseConnection(Driver driver, String username, String password, String url) {
		// we got here, so it was successful.
		Properties dbInfo = new Properties();
		dbInfo.put("user", username);
		dbInfo.put("password", password);
		Connection conn = null;

		try {
			conn = driver.connect(url, dbInfo);
		}
        catch (Exception e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
            String error =
                    AutomatedInstallData.getInstance().langpack.getString("JBossJDBCDriverSetupPanel.connection.error")
                    + "\n"
                    + e;
                    //e.getClass().getName());
            return error;
		}
		 //java.lang.UnsupportedOperationException:
        //SQLException
		return conn;
	}
	
	/**
	 * 
	 * Returns an int based upon the result of various checks:<br/>
	 * 0 : all is well <br/>
	 * 1 : given path doesn't exist / is a directory<br/>
	 * 2 : given path is not a zip<br/>
	 * 3 : given path is an empty zip<br/>
	 * 4 : given remote path is not accessible by the installer<br/>
	 * 5 : Exception
	 * 
	 * 
	 * 
	 * @param jar
	 * @return
	 */
	public static int verifyJarPath(String jar){				
		if (jar.equals("http://") || jar.equals("ftp://")){
			return 4;
		} else if (jar.startsWith("http://")) {
			try {
				HttpURLConnection.setFollowRedirects(true);
				HttpURLConnection connection = (HttpURLConnection) new URL(jar).openConnection();
				connection.setRequestMethod("HEAD");
				int resp = connection.getResponseCode();
				if (resp != HttpURLConnection.HTTP_OK){
					return 4;
				}
			} catch (Exception e) {
				
				return 4;
			}
		} else if( jar.startsWith("ftp://")) {
			try {
		          URL url = new URL(jar);
		          	
		          InputStream check = url.openStream();

		            } catch (Exception ex) {
		            	return 4;
		            }		
		} else {
			ZipFile zipFile = null;
			try {
				zipFile = new ZipFile(jar);
			} catch (FileNotFoundException fnf) {
				// file doesn't exist.
				return 1;
			} catch (ZipException ze) {
				return 2;
			} catch (IOException ioe) {
				// catastrophe
				ioe.printStackTrace();
				return 5;
			}

			Enumeration<? extends ZipEntry> entries = zipFile.entries();
			// we reached here and no entries? not a zip file.
			if (!entries.hasMoreElements()) {
				// close the file
				try {
					zipFile.close();
				} catch (IOException ioe) {
					// more catastrophe
					ioe.printStackTrace();
				}
				return 3;
			}
		}
		return 0;
	}
	

	/**
	 * Finds a class name in a given set of urls, which can contain local or remote jars<br/>
	 * returns null if the class is not found, or the Class object which was loaded. 
	 */
	public static Class<?> findDriverClass(String driverClassName, URL[] jarUrls) {
        if (driverClassName == null) return null;
		URLClassLoader loader = null;
		Class<?> driverClass = null;


        try {
            // closing this causes CNFE's. May have to look into how to close a CL properly
            loader = new URLClassLoader(jarUrls);
            driverClass = loader.loadClass(driverClassName);
        } catch (ClassNotFoundException cnfe) {
            //cnfe.printStackTrace();
        }  catch (SecurityException se) {
            //exception.printStackTrace
        } catch (Exception e) {
            e.printStackTrace();
        }

		return driverClass;
	}
/*
	public static Object[] getDriverJars(AutomatedInstallData adata) {
		ArrayList<String> jarList = new ArrayList<String>(1); 
		int counter = 1; 
		while (true) {
			String path = adata.getVariable("jdbc.driver.jar-" + counter + "-path");
			if (path != null) {
					jarList.add(path);
					counter++;	
			} else {
				// no more. we're done.
				break;
			}
		}
		return jarList.toArray();
	}*/
}
