package com.redhat.installer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeystoreUtils {
	/**
	 * This method checks that a given keystore<br/>
	 * a) exists (file) or is accessible (remote)<br/>
	 * b) the provided password is correct for the keystore<br/>
	 * Valid return values:<br/>
	 * 0 : everything is fine <br/>
	 * 1 : authentication failure<br/>
	 * 2 : file doesn't exist / hostname not accessible
	 * TODO: check more types of keystore. extremely limited test right now.
	 * TODO: the Security.getProviders() method looks promising for this
	 * @param keystoreUrl
	 * @param pwd
	 * @return
	 */
	
	public static int isValidKeystore(String keystoreUrl, char[] pwd) {
		boolean notFile = false;

		if ((notFile = !isValidReadableFile(keystoreUrl)) && !isValidAccessibleUrl(keystoreUrl)){
			//setError("The given location doesn't seem to be valid.");
			return 2;
		}
		
		KeyStore ks = null;
		try {
			ks = KeyStore.getInstance(KeyStore.getDefaultType());
			if (!notFile){ // local
				ks.load(new FileInputStream(new File(keystoreUrl)), pwd);
			} else {
				// remote
				ks.load(new URL(keystoreUrl).openStream(), pwd);
			}
		} catch (MalformedURLException e){
			// this should never be thrown thanks to the isValidAccessibleUrl call
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			// may occur if the user is using a bizarre JRE that doesn't include JavaKeyStore format
			e.printStackTrace();
		} catch (CertificateException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			// impossible to be thrown because of the vall to isValidReadableFile
			e.printStackTrace();
		} catch (IOException e) {
			//setError("Keystore password is incorrect.");
			return 1;
			// one of the IOExceptions is UnrecoverableKeyException, which is not all that specific for us.
			// i had originally had in a check, but i realized it was of little value
/*			Class<? extends Throwable> cause = e.getCause().getClass();
			if (cause.isAssignableFrom(UnrecoverableKeyException.class)){
				// assume password is wrong?
				setError("Keystore password is incorrect.");
				return false;
			} else {
				e.printStackTrace();
			}*/

		} catch (KeyStoreException e) {
			// this shouldn't really happen ever
			// if this is thrown, again, the JRE doesn't include a Provider that can provide a KeyStore instance of type "JKS", which 
			// means that either the JRE is very old or is non-standard in some critical way
			e.printStackTrace();
		}
		// loading was successful
		// i guess that's all we need? 
		return 0;
		
	}

	
	/**
	 * Determines if a given file exists, can be read, and isn't a directory
	 * TODO: This could probably be moved to another util class to be utilized by other classes
	 * @param file
	 * @return
	 */
	public static boolean isValidReadableFile(String file) {
		File check = new File(file);
		if (check.exists() && check.canRead() && !check.isDirectory()){
			return true;
		} else {
			return false;	
		}
	}

	/**
	 * Determines if a given URL is both valid and accessible
	 * TODO: this could probably be moved to another util class and utilized elsewhere
	 * @param url
	 * @return
	 */
	public static boolean isValidAccessibleUrl(String url) {
		URL check;
		try {
			check = new URL(url);
		} catch (MalformedURLException e1) {
			return false;
		}
		// not sure about this HttpURLConnection.setFollowRedirects(false);
	
		try {
			HttpURLConnection conn = (HttpURLConnection)check.openConnection();
			conn.setRequestMethod("HEAD");
			return conn.getResponseCode() == HttpURLConnection.HTTP_OK;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
			return false;
		} 
	}
	
}
