package com.redhat.installer.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.util.KeystoreUtils;

public class PreExistingVaultValidator implements DataValidator{

	private String error;
	
	@Override
	public Status validateData(AutomatedInstallData adata) {
		String keystoreLoc = adata.getVariable("vault.keystoreloc"); // this should be automatically filled for us
		char [] pwd = adata.getVariable("vault.keystorepwd").toCharArray();
		int result = KeystoreUtils.isValidKeystore(keystoreLoc, pwd);
		
		if (result == 0){
			adata.setVariable("installVault","on");
			return Status.OK;
		} else {
			setError(adata.langpack.getString("ssl.password.incorrect"));
			return Status.WARNING;
		}
	}
	
	private void setError(String s){
		this.error = s;
	}

	@Override
	public String getErrorMessageId() {
		return error;
	}

	@Override
	public String getWarningMessageId() {
		return error;
	}

	@Override
	public boolean getDefaultAnswer() {
		return false;
	}
}
