# Overlord Runtime Governance (RTGov)

Any feature requests or issues with the RTGov component should be reported here: https://issues.jboss.org/browse/RTGOV


## Setting up the environment

When building the repository, the 'release' folder is platform specific and therefore need a
target platform to be specified. All other folders are platform agnostic.

The following environment needs to be setup for the selected target platform:


JBossAS7/Switchyard:

The 'jbossas' target platform requires JBossAS7 with Switchyard. This can be obtained from: http://www.jboss.org/switchyard/downloads

(Note: currently requires switchyard-1.0 or later).

Once installed, set the JBOSS_HOME environment variable to point to the root of the switchyard installation.



## Building the distribution

From the root folder, build the distribution using:

**mvn clean install -P&lt;platform&gt;**

where platform can be: jbossas 


Once the build has completed, the distribution can be found in the release/jbossas/distribution/target folder.


### Generating Javadocs

An aggregate set of javadocs can be generated from the root folder using the following command:

**mvn javadoc:javadoc**

The javadocs will be generated to the target/site folder.


### Running Performance Tests

To run the performance tests on a particular platform, simply add the '-Pperformance' option performing the build.

The performance tests use the standard SLA monitor sample and check that under heavy load that the time taken to
process the activity events generated by the application is less than the time it takes to actually execute all
of the transactions - thus indicating that the Runtime Governance infrastructure is keeping up.


## Contributing

Before submitting a pull request, please perform the following command from the root folder, to check for style issues:

**mvn checkstyle:checkstyle**

If any errors are reported, then they should be fixed before submitting the pull request.

