package io.hawt.web;

import io.hawt.system.ConfigManager;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;

/**
 *  Returns the username associated with the current session, if any
 */
public class UserServlet extends HttpServlet {

    protected ConfigManager config;
    private boolean authenticationEnabled = true;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        config = (ConfigManager) servletConfig.getServletContext().getAttribute("ConfigManager");
        this.authenticationEnabled = Boolean.parseBoolean(config.get("authenticationEnabled", "true"));
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        final PrintWriter out = resp.getWriter();

        if (!authenticationEnabled) {
            out.write("\"user\"");
            out.flush();
            out.close();
            return;
        }

        HttpSession session = req.getSession(false);

        if (session != null) {
            String username = (String) session.getAttribute("user");
            out.write("\"" + username + "\"");
        } else {
            out.write("");
        }
        out.flush();
        out.close();
    }
}
