/*
 * Copyright 2013 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.util.regex.Pattern;

/**
 * @author dbokde
 */
public class FuseServerDiscoveryComponentTest extends Assert {

    private static final String TEST_FILE = "fuse/FuseServerDiscoveryComponentTest(\\.class)";

    @Test
    public void testFindVersionFile() throws Exception {
        final FuseServerDiscoveryComponent component = new FuseServerDiscoveryComponent();
        // create test directory structure
        final File currentDir = new File(System.getProperty("user.dir"));
        assertNotNull("Missing file " + TEST_FILE,
            component.findVersionFile(currentDir, Pattern.compile(TEST_FILE)));
    }

}
