/*
 * #%L
 * Fuse EAP :: Config
 * %%
 * Copyright (C) 2015 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.jboss.fuse.eap.config;

import de.pdark.decentxml.Document;
import org.junit.Test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static org.jboss.fuse.eap.config.LayerConfig.Type.INSTALLING;
import static org.jboss.fuse.eap.config.LayerConfig.Type.OPTIONAL;
import static org.jboss.fuse.eap.config.LayerConfig.Type.REQUIRED;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

public class ConfigSupportTest {

    @Test
    public void testApplyLayerConfigChange() {


        ConfigEditor editor = new ConfigEditor() {
            @Override
            public void applyDomainConfigChange(boolean enable, Document doc) {
            }

            @Override
            public void applyStandaloneConfigChange(boolean enable, Document doc) {
            }

            @Override
            public List<LayerConfig> getLayerConfigs() {
                return Arrays.asList(
                        new LayerConfig("fuse_6.2.1", INSTALLING, -10),
                        new LayerConfig("soa_6.2.1", INSTALLING, -10),
                        new LayerConfig("brms_6.2.1", OPTIONAL, -11)
                );
            }
        };

        // Install/Uninstall scenario.
        ArrayList<String> layers = list("foo", "example");
        ConfigSupport.applyLayerConfigChange(true, editor, layers);
        assertEquals(list("fuse_6.2.1", "soa_6.2.1", "foo", "example"), layers);
        ConfigSupport.applyLayerConfigChange(false, editor, layers);
        assertEquals(list("foo", "example"), layers);

        // Upgrade/Uninstall scenario.
        layers = list("foo", "fuse_6.1", "soa", "example");
        ConfigSupport.applyLayerConfigChange(true, editor, layers);
        assertEquals(list("fuse_6.2.1", "soa_6.2.1", "foo", "example"), layers);
        ConfigSupport.applyLayerConfigChange(false, editor, layers);
        assertEquals(list("foo", "example"), layers);

        // Another Upgrade/Uninstall scenario.
        layers = list("foo", "fuse", "example");
        ConfigSupport.applyLayerConfigChange(true, editor, layers);
        assertEquals(list("fuse_6.2.1", "soa_6.2.1", "foo", "example"), layers);
        ConfigSupport.applyLayerConfigChange(false, editor, layers);
        assertEquals(list("foo", "example"), layers);

    }

    @Test
    public void testApplyLayerConfigChange2() {


        ConfigEditor editor = new ConfigEditor() {
            @Override
            public void applyDomainConfigChange(boolean enable, Document doc) {
            }

            @Override
            public void applyStandaloneConfigChange(boolean enable, Document doc) {
            }

            @Override
            public List<LayerConfig> getLayerConfigs() {
                return Arrays.asList(
                        new LayerConfig("fuse_6.2.1", REQUIRED, -10),
                        new LayerConfig("soa_6.2.1", REQUIRED, -10),
                        new LayerConfig("brms_6.2.1", INSTALLING, -9)
                );
            }
        };

        // Install/Uninstall scenario.
        ArrayList<String> layers = null;
        try {
            layers = list("foo", "example");
            ConfigSupport.applyLayerConfigChange(true, editor, layers);
            fail("Expecting exception since required modules are not installed");
        } catch (Exception e) {
        }

        layers = list("fuse", "soa");
        ConfigSupport.applyLayerConfigChange(true, editor, layers);
        assertEquals(list("fuse", "soa", "brms_6.2.1"), layers);
    }

    private ArrayList<String> list(String... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }
}

