/*
 * Copyright 2015 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse.utils;

/**
 * Utility interface to connect to Fabric registry.
 *
 * @author dbokde
 */
public interface FabricRegistry {

    /**
     * Connect to registry.
     * @throws Exception on error.
     */
    void connect() throws Exception;

    /**
     * Disconnect from registry closing any resources.
     * @throws Exception on error
     */
    void disconnect() throws Exception;

    /**
     * Gets container version.
     * @return container version string.
     * @throws Exception on error.
     */
    String getContainerVersion() throws Exception;

    /**
     * Gets container profiles.
     * @param containerVersion container's current version.
     * @return profile names used directly by container.
     * @throws Exception on error.
     */
    String[] getContainerProfiles(String containerVersion) throws Exception;

    /**
     * Writes a test node to the specified zookeeper location.
     * @param key In Zookeeper registry.
     * @throws Exception on error.
     */
    void writeTextNode(String key, String value) throws Exception;

    /**
     * Reads a text node from the  specified zookeeper location.
     * Returns null in case node is not existing
     * @param key In Zookeeper registry.
     * @throws Exception on error.
     */
    String getTextNode(String key) throws Exception;

}
