/*
 * Copyright 2015 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

/**
 * @author dbokde
 */
public class KarafServerDiscoveryComponent extends FuseServerDiscoveryComponent {

    private static final String KARAF_BASE_PROPERTY = "karaf.base";
    private static final String KARAF_HOME_PROPERTY = "karaf.home";
    private static final String CHILD_PREFIX = "Child ";

    @Override
    protected boolean populateResourceProperties(ResourceDiscoveryContext context, DiscoveredResourceDetails details) {
        if (!super.populateResourceProperties(context, details)) {
            return false;
        }

        // check if karaf.base matches karaf.home, if it doesn't add CHILD_PREFIX to name and description
        Configuration config = details.getPluginConfiguration();
        if (!config.getSimpleValue(KARAF_HOME_PROPERTY).equals(config.getSimpleValue(KARAF_BASE_PROPERTY))) {
            // replace resource type in name and description to "Child " + resourceType name
            String resourceTypeName = details.getResourceType().getName();
            details.setResourceName(details.getResourceName().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
            details.setResourceDescription(details.getResourceDescription().replace(resourceTypeName, CHILD_PREFIX + resourceTypeName));
        }
        return true;
    }

}
