/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.AbstractConnection;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.rfc.engine.BgRfcUnit;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;
import java.util.Set;

public abstract class JCoMiddleware {
    public abstract String[][] getPropertyInfo();

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public abstract String getName();

    public abstract String getVersion();

    protected int getMaxStartupDelay() {
        return 3600;
    }

    public abstract Client getClientInterface();

    public abstract Server getServerInterface();

    public abstract ServerGroup getListenerGroupInterface();

    public abstract Dispatcher getDispatcherInterface();

    protected abstract void removeProperty(String var1, Properties var2);

    protected abstract JCoException generateJCoException(RfcException var1);

    class CallContext {
        BgRfcUnit bgRfcUnit;
        String tid24;
        byte[] unitIdBytes;
        Set<String> queueSet;
        String queueName;
        AbstractConnection conn;
        JCoRepository repository;

        CallContext() {
        }

        void reset(AbstractConnection connection) {
            this.conn = connection;
            this.tid24 = null;
            this.unitIdBytes = null;
            this.queueSet = null;
            this.queueName = null;
        }

        void startBgRfcUnit(AbapFunctionUnit unit) {
            this.unitIdBytes = unit.guid;
            this.queueSet = unit.queueSet;
            this.bgRfcUnit = this.conn.rfcHandle.RfcStartBgRfcUnit(this.unitIdBytes);
            this.bgRfcUnit.setQueueNames(unit.queueSet);
            this.bgRfcUnit.setAttributes(unit.unitAttributes);
        }

        void startQRfc(String tid, String queue) {
            this.tid24 = tid;
            this.queueName = queue;
        }

        boolean isTRfc() throws JCoException {
            if (this.tid24 != null) {
                if (this.tid24.length() > 24) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of TID encountered [" + this.tid24 + "]");
                }
                return true;
            }
            if (this.queueName != null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "TID is null, even though queuename [" + this.queueName + "] has been provided");
            }
            return false;
        }

        boolean isBgRfc() throws JCoException {
            if (this.unitIdBytes != null) {
                if (this.unitIdBytes.length != 16) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of unit guid encountered [" + Codecs.Hex.encode(this.unitIdBytes) + "]");
                }
                return true;
            }
            if (this.queueSet != null && !this.queueSet.isEmpty()) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unit guid is null even though a non-empty queue set has been provided");
            }
            return false;
        }

        boolean isQRfc() throws JCoException {
            if (this.queueName != null) {
                if (this.queueName.length() > 24) {
                    throw new JCoException(101, "JCO_ERROR_PROGRAM", "Incorrect size of queue name encountered [" + this.queueName + "]");
                }
                return true;
            }
            return false;
        }

        boolean isTransactional() throws JCoException {
            return this.isTRfc() || this.isBgRfc();
        }

        public void commit() throws JCoException {
            if (this.bgRfcUnit != null) {
                try {
                    this.conn.rfcHandle.RfcCommit(this.bgRfcUnit, this.repository);
                }
                catch (RfcException re) {
                    throw JCoMiddleware.this.generateJCoException(re);
                }
            }
        }
    }

    public static interface Server
    extends Connection {
        public static final String JCO_GWHOST = "jco.server.gwhost";
        public static final String JCO_GWSERV = "jco.server.gwserv";
        public static final String JCO_PROGID = "jco.server.progid";
        public static final String JCO_TRACE = "jco.server.trace";
        public static final String JCO_SNC_MODE = "jco.server.snc_mode";
        public static final String JCO_SNC_MYNAME = "jco.server.snc_myname";
        public static final String JCO_SNC_QOP = "jco.server.snc_qop";
        public static final String JCO_SNC_LIBRARY = "jco.server.snc_lib";
        public static final String JCO_MAX_STARTUP_DELAY = "jco.server.max_startup_delay";
        public static final String JCO_SAPROUTER = "jco.server.saprouter";
        public static final String JCO_TYPE = "jco.server.type";
        public static final String JCO_GROUP_KEY = "jco.server.group_key";
        public static final String JCO_SERVER_NAME = "jco.server.name";

        public String[][] getPropertyInfo();

        public void accept(ServerConnection var1) throws JCoException;

        public void listen(ServerWorker var1) throws JCoException;

        public void abort(ServerWorker var1, String var2) throws JCoException;

        public void disconnect(ServerConnection var1);

        public void getAttributes(ServerConnection var1) throws JCoException;

        public String createSessionId(ServerConnection var1);

        public void execute(ServerWorker var1, String var2, DefaultParameterList var3, DefaultParameterList var4, DefaultParameterList var5, DefaultParameterList var6, boolean var7, AbapClassException.Mode var8) throws JCoException;
    }

    public static abstract class Dispatcher {
        public static final int RC_RETRY_LISTEN = 0;
        public static final int RC_DISPATCH_CALL = 1;

        protected abstract int waitForRequest(int var1);

        protected abstract ServerConnection getNextListener();

        public abstract int getNumServerConnections(Properties var1) throws JCoException;
    }

    public static interface ServerGroup {
        public String initialize(Properties var1);

        public Object getAcceptParameters();
    }

    public static interface Client
    extends Connection {
        public static final String JCO_PASSWD = "jco.client.passwd";
        public static final String JCO_CLIENT = "jco.client.client";
        public static final String JCO_USER = "jco.client.user";
        public static final String JCO_ALIAS_USER = "jco.client.alias_user";
        public static final String JCO_LANG = "jco.client.lang";
        public static final String JCO_CODEPAGE = "jco.client.codepage";
        public static final String JCO_SYSNR = "jco.client.sysnr";
        public static final String JCO_ASHOST = "jco.client.ashost";
        public static final String JCO_MSHOST = "jco.client.mshost";
        public static final String JCO_GWHOST = "jco.client.gwhost";
        public static final String JCO_GWSERV = "jco.client.gwserv";
        public static final String JCO_R3NAME = "jco.client.r3name";
        public static final String JCO_GROUP = "jco.client.group";
        public static final String JCO_TPHOST = "jco.client.tphost";
        public static final String JCO_TPNAME = "jco.client.tpname";
        public static final String JCO_TYPE = "jco.client.type";
        public static final String JCO_TRACE = "jco.client.trace";
        public static final String JCO_MYSAPSSO2 = "jco.client.mysapsso2";
        public static final String JCO_GETSSO2 = "jco.client.getsso2";
        public static final String JCO_X509CERT = "jco.client.x509cert";
        public static final String JCO_EXTIDDATA = "jco.client.extiddata";
        public static final String JCO_EXTIDTYPE = "jco.client.extidtype";
        public static final String JCO_LCHECK = "jco.client.lcheck";
        public static final String JCO_SNC_PARTNERNAME = "jco.client.snc_partnername";
        public static final String JCO_SNC_QOP = "jco.client.snc_qop";
        public static final String JCO_SNC_MYNAME = "jco.client.snc_myname";
        public static final String JCO_SNC_MODE = "jco.client.snc_mode";
        public static final String JCO_SNC_LIBRARY = "jco.client.snc_lib";
        public static final String JCO_DEST = "jco.client.dest";
        public static final String JCO_SAPLOGON_ID = "jco.client.saplogon_id";
        public static final String JCO_MSSERV = "jco.client.msserv";
        public static final String JCO_ICCE = "jco.client.icce";
        public static final String JCO_IDLE_TIMEOUT = "jco.client.idle_timeout";
        public static final String JCO_SAPROUTER = "jco.client.saprouter";
        public static final String JCO_DESTINATION = "jco.client.destination";

        public String[][] getPropertyInfo();

        public void connect(ClientConnection var1) throws JCoException;

        public void initialize(Properties var1) throws JCoException;

        public void abort(ClientConnection var1, String var2) throws JCoException;

        public void reset(ClientConnection var1) throws JCoException;

        public void getAttributes(ClientConnection var1) throws JCoException;

        public CallContext getCallContext(ClientConnection var1) throws JCoException;

        public void execute(ClientConnection var1, String var2, DefaultParameterList var3, DefaultParameterList var4, DefaultParameterList var5, DefaultParameterList var6, boolean var7, AbapClassException.Mode var8) throws JCoException;

        public void confirmTID(ClientConnection var1, String var2) throws JCoException;

        public void confirmUnitID(ClientConnection var1, JCoUnitIdentifier var2) throws JCoException;

        public String createTID(ClientConnection var1) throws JCoException;

        public Object getConnectionState(ClientConnection var1) throws JCoException;

        public void restoreConnection(ClientConnection var1, Object var2) throws JCoException;

        public void free(ClientConnection var1);

        @Override
        public Client createCopy();
    }

    public static interface Connection {
        public void releaseHandle(AbstractConnection var1);

        public boolean isAlive(AbstractConnection var1);

        public void disconnect(AbstractConnection var1) throws JCoException;

        public void abort(AbstractConnection var1, String var2) throws JCoException;

        public void cancel(AbstractConnection var1) throws JCoException;

        public Connection createCopy();
    }
}

