/**
 * Useful entry class for CLI testing. It replicates how PME will run the tool in a very simplistic
 * way (it only processes the working directory).
 * Run with e.g.
 * ~/Software/groovy-2.4.5/bin/groovy -cp "~/.m2/repository/org/slf4j/slf4j-simple/1.7.7/slf4j-simple-1.7.7.jar:~/.m2/repository/org/slf4j/slf4j-api/1.7.7/slf4j-api-1.7.7.jar" ~/Work/SOA-P-6/soa-component-management-master/fabric8/src/main/resources/bom/Entry.groovy
 */

/*
 * Specifying 'slf4j-simple' rather than 'slf4j-api' to avoid the error
 * "Failed to load class "org.slf4j.impl.StaticLoggerBinder" that is caused by
 * specifying no or more than one of the actual logging binding libraries to
 * be used (see http://www.slf4j.org/codes.html#StaticLoggerBinder). One should
 * be selected from 'slf4j-nop', 'slf4j-simple', 'slf4j-log4j12.jar',
 * 'slf4j-jdk14', or 'logback-classic'. An example of specifying the SLF4J
 * dependency via @Grab is available at
 * http://mvnrepository.com/artifact/org.slf4j/slf4j-api/1.6.1.
 */
@Grapes([
            @Grab(group='org.slf4j', module='slf4j-simple', version='1.6.1')
        ])


/*
@Slf4j
class Main
{
    static void main(String... args) {
    }
}
*/


String scriptDir = new File(getClass().protectionDomain.codeSource.location.path).parent
File groovyFile = new File(scriptDir.toString() + "/PreProcessor.groovy");

def sharedData = new Binding()
sharedData.setProperty( "basedir", new File(".").getCanonicalPath().toString() );
sharedData.setProperty( "name", "###UNKOWN###" );
def shell = new GroovyShell(sharedData)

shell.evaluate(groovyFile)
