/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package v1beta2

import (
	v1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	scheme "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AddressPlansGetter has a method to return a AddressPlanInterface.
// A group's client should implement this interface.
type AddressPlansGetter interface {
	AddressPlans(namespace string) AddressPlanInterface
}

// AddressPlanInterface has methods to work with AddressPlan resources.
type AddressPlanInterface interface {
	Create(*v1beta2.AddressPlan) (*v1beta2.AddressPlan, error)
	Update(*v1beta2.AddressPlan) (*v1beta2.AddressPlan, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta2.AddressPlan, error)
	List(opts v1.ListOptions) (*v1beta2.AddressPlanList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressPlan, err error)
	AddressPlanExpansion
}

// addressPlans implements AddressPlanInterface
type addressPlans struct {
	client rest.Interface
	ns     string
}

// newAddressPlans returns a AddressPlans
func newAddressPlans(c *AdminV1beta2Client, namespace string) *addressPlans {
	return &addressPlans{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the addressPlan, and returns the corresponding addressPlan object, and an error if there is any.
func (c *addressPlans) Get(name string, options v1.GetOptions) (result *v1beta2.AddressPlan, err error) {
	result = &v1beta2.AddressPlan{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addressplans").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AddressPlans that match those selectors.
func (c *addressPlans) List(opts v1.ListOptions) (result *v1beta2.AddressPlanList, err error) {
	result = &v1beta2.AddressPlanList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addressplans").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested addressPlans.
func (c *addressPlans) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("addressplans").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a addressPlan and creates it.  Returns the server's representation of the addressPlan, and an error, if there is any.
func (c *addressPlans) Create(addressPlan *v1beta2.AddressPlan) (result *v1beta2.AddressPlan, err error) {
	result = &v1beta2.AddressPlan{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("addressplans").
		Body(addressPlan).
		Do().
		Into(result)
	return
}

// Update takes the representation of a addressPlan and updates it. Returns the server's representation of the addressPlan, and an error, if there is any.
func (c *addressPlans) Update(addressPlan *v1beta2.AddressPlan) (result *v1beta2.AddressPlan, err error) {
	result = &v1beta2.AddressPlan{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("addressplans").
		Name(addressPlan.Name).
		Body(addressPlan).
		Do().
		Into(result)
	return
}

// Delete takes name of the addressPlan and deletes it. Returns an error if one occurs.
func (c *addressPlans) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addressplans").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *addressPlans) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addressplans").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched addressPlan.
func (c *addressPlans) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressPlan, err error) {
	result = &v1beta2.AddressPlan{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("addressplans").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
