import * as React from 'react';
export interface InternalDropdownItemProps extends React.HTMLProps<HTMLAnchorElement> {
    /** Anything which can be rendered as dropdown item */
    children?: React.ReactNode;
    /** Classes applied to root element of dropdown item */
    className?: string;
    /** Class applied to list element */
    listItemClassName?: string;
    /** Indicates which component will be used as dropdown item */
    component?: React.ReactNode | string;
    /** Role for the item */
    role?: string;
    /** Render dropdown item as disabled option */
    isDisabled?: boolean;
    /** Forces display of the hover state of the element */
    isHovered?: boolean;
    /** Default hyperlink location */
    href?: string;
    /** Tooltip to display when hovered over the item */
    tooltip?: React.ReactNode;
    /** Additional tooltip props forwarded to the Tooltip component */
    tooltipProps?: any;
    index?: number;
    context?: {
        keyHandler?: (index: number, direction: string) => void;
        sendRef?: (index: number, ref: any, isDisabled: boolean, isSeparator: boolean) => void;
    };
    /** Callback for click event */
    onClick?: (event: React.MouseEvent<any> | React.KeyboardEvent | MouseEvent) => void;
    /** ID for the list element */
    id?: string;
    /** ID for the component element */
    componentID?: string;
}
export declare class InternalDropdownItem extends React.Component<InternalDropdownItemProps> {
    ref: React.RefObject<HTMLLIElement>;
    static defaultProps: {
        className: string;
        isHovered: boolean;
        component: string;
        role: string;
        isDisabled: boolean;
        href: string;
        tooltipProps: {};
        onClick: (event: React.MouseEvent<HTMLAnchorElement, MouseEvent>) => any;
        onSelect: () => any;
        index: number;
        context: {
            keyHandler: Function;
            sendRef: Function;
        };
        id: string;
        componentID: string;
    };
    componentDidMount(): void;
    onKeyDown: (event: any) => void;
    render(): JSX.Element;
}
