/// <reference types="node" />
import { HooksContext } from './hooks';
import { Addon } from './index';
export declare enum types {
    TAB = "tab",
    PANEL = "panel",
    TOOL = "tool",
    PREVIEW = "preview",
    NOTES_ELEMENT = "notes-element"
}
export declare type Types = types | string;
export declare function isSupportedType(type: Types): boolean;
export interface Parameters {
    fileName?: string;
    options?: OptionsParameter;
    [key: string]: any;
}
export interface StoryContext {
    id: string;
    name: string;
    kind: string;
    [key: string]: any;
    parameters: Parameters;
    hooks?: HooksContext;
}
export interface WrapperSettings {
    options: OptionsParameter;
    parameters: {
        [key: string]: any;
    };
}
export interface OptionsParameter extends Object {
    storySort?: any;
    hierarchyRootSeparator?: string;
    hierarchySeparator?: RegExp;
    theme?: {
        base: string;
        brandTitle?: string;
    };
    [key: string]: any;
}
export declare type StoryGetter = (context: StoryContext) => any;
export declare type StoryFn<ReturnType = unknown> = (p?: StoryContext) => ReturnType;
export declare type StoryWrapper = (getStory: StoryGetter, context: StoryContext, settings: WrapperSettings) => any;
export declare type MakeDecoratorResult = (...args: any) => any;
export interface AddStoryArgs<StoryFnReturnType = unknown> {
    id: string;
    kind: string;
    name: string;
    storyFn: StoryFn<StoryFnReturnType>;
    parameters: Parameters;
}
export interface ClientApiAddon<StoryFnReturnType = unknown> extends Addon {
    apply: (a: StoryApi<StoryFnReturnType>, b: any[]) => any;
}
export interface ClientApiAddons<StoryFnReturnType> {
    [key: string]: ClientApiAddon<StoryFnReturnType>;
}
export declare type ClientApiReturnFn<StoryFnReturnType> = (...args: any[]) => StoryApi<StoryFnReturnType>;
export interface StoryApi<StoryFnReturnType = unknown> {
    kind: string;
    add: (storyName: string, storyFn: StoryFn<StoryFnReturnType>, parameters?: Parameters) => StoryApi<StoryFnReturnType>;
    addDecorator: (decorator: DecoratorFunction<StoryFnReturnType>) => StoryApi<StoryFnReturnType>;
    addParameters: (parameters: Parameters) => StoryApi<StoryFnReturnType>;
    [k: string]: string | ClientApiReturnFn<StoryFnReturnType>;
}
export declare type DecoratorFunction<StoryFnReturnType = unknown> = (fn: StoryFn<StoryFnReturnType>, c: StoryContext) => ReturnType<StoryFn<StoryFnReturnType>>;
export interface ClientStoryApi<StoryFnReturnType = unknown> {
    storiesOf(kind: string, module: NodeModule): StoryApi<StoryFnReturnType>;
    addDecorator(decorator: DecoratorFunction<StoryFnReturnType>): StoryApi<StoryFnReturnType>;
    addParameters(parameter: Parameters): StoryApi<StoryFnReturnType>;
}
declare type LoadFn = () => any;
declare type RequireContext = any;
export declare type Loadable = RequireContext | [RequireContext] | LoadFn;
export {};
