"use strict";

require("core-js/modules/es.object.define-property");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconButton = exports.TabButton = void 0;

var _theming = require("@storybook/theming");

var TabButton = _theming.styled.button({
  whiteSpace: 'normal',
  display: 'inline-flex',
  overflow: 'hidden',
  verticalAlign: 'top',
  justifyContent: 'center',
  alignItems: 'center',
  textAlign: 'center',
  textDecoration: 'none',
  '&:empty': {
    display: 'none'
  }
}, function (_ref) {
  var theme = _ref.theme;
  return {
    padding: '0 15px',
    textTransform: 'capitalize',
    transition: 'color 0.2s linear, border-bottom-color 0.2s linear',
    height: 40,
    lineHeight: '12px',
    cursor: 'pointer',
    background: 'transparent',
    border: '0 solid transparent',
    borderTop: '3px solid transparent',
    borderBottom: '3px solid transparent',
    fontWeight: 'bold',
    fontSize: 13,
    '&:focus': {
      outline: '0 none',
      borderBottomColor: theme.color.secondary
    }
  };
}, function (_ref2) {
  var active = _ref2.active,
      textColor = _ref2.textColor,
      theme = _ref2.theme;
  return active ? {
    color: textColor || theme.barSelectedColor,
    borderBottomColor: theme.barSelectedColor
  } : {
    color: textColor || 'inherit',
    borderBottomColor: 'transparent'
  };
});

exports.TabButton = TabButton;
TabButton.displayName = 'TabButton';

var IconButton = _theming.styled.button(function (_ref3) {
  var theme = _ref3.theme;
  return {
    height: 40,
    background: 'none',
    color: 'inherit',
    padding: 0,
    cursor: 'pointer',
    border: '0 solid transparent',
    borderTop: '3px solid transparent',
    borderBottom: '3px solid transparent',
    transition: 'color 0.2s linear, border-bottom-color 0.2s linear',
    '&:hover, &:focus': {
      outline: '0 none',
      color: theme.color.secondary
    },
    '& > svg': {
      width: 15
    }
  };
}, function (_ref4) {
  var active = _ref4.active,
      theme = _ref4.theme;
  return active ? {
    outline: '0 none',
    borderBottomColor: theme.color.secondary
  } : {};
});

exports.IconButton = IconButton;
IconButton.displayName = 'IconButton';