"use strict";

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetWrapper = exports.TT = exports.Code = exports.P = exports.OL = exports.UL = exports.LI = exports.Span = exports.Div = exports.Img = exports.Table = exports.Blockquote = exports.DL = exports.HR = exports.A = exports.Pre = exports.H6 = exports.H5 = exports.H4 = exports.H3 = exports.H2 = exports.H1 = void 0;

var _theming = require("@storybook/theming");

var _withReset = require("./withReset");

var headerCommon = function headerCommon(_ref) {
  var theme = _ref.theme;
  return {
    margin: '20px 0 8px',
    padding: 0,
    cursor: 'text',
    position: 'relative',
    color: theme.color.defaultText,
    '&:first-of-type': {
      marginTop: 0,
      paddingTop: 0
    },
    '&:hover a.anchor': {
      textDecoration: 'none'
    },
    '& tt, & code': {
      fontSize: 'inherit'
    }
  };
};

var withMargin = {
  margin: '16px 0'
};

var H1 = _theming.styled.h1(_withReset.withReset, headerCommon, function (_ref2) {
  var theme = _ref2.theme;
  return {
    fontSize: "".concat(theme.typography.size.l1, "px"),
    fontWeight: theme.typography.weight.black
  };
});

exports.H1 = H1;

var H2 = _theming.styled.h2(_withReset.withReset, headerCommon, function (_ref3) {
  var theme = _ref3.theme;
  return {
    fontSize: "".concat(theme.typography.size.m2, "px"),
    paddingBottom: '4px',
    borderBottom: "1px solid ".concat(theme.appBorderColor)
  };
});

exports.H2 = H2;

var H3 = _theming.styled.h3(_withReset.withReset, headerCommon, function (_ref4) {
  var theme = _ref4.theme;
  return {
    fontSize: "".concat(theme.typography.size.m1, "px")
  };
});

exports.H3 = H3;

var H4 = _theming.styled.h4(_withReset.withReset, headerCommon, function (_ref5) {
  var theme = _ref5.theme;
  return {
    fontSize: "".concat(theme.typography.size.s3, "px")
  };
});

exports.H4 = H4;

var H5 = _theming.styled.h5(_withReset.withReset, headerCommon, function (_ref6) {
  var theme = _ref6.theme;
  return {
    fontSize: "".concat(theme.typography.size.s2, "px")
  };
});

exports.H5 = H5;

var H6 = _theming.styled.h6(_withReset.withReset, headerCommon, function (_ref7) {
  var theme = _ref7.theme;
  return {
    fontSize: "".concat(theme.typography.size.s2, "px"),
    color: theme.color.dark
  };
});

exports.H6 = H6;

var Pre = _theming.styled.pre(_withReset.withReset, withMargin, function (_ref8) {
  var theme = _ref8.theme;
  return {
    // reset
    fontFamily: theme.typography.fonts.mono,
    WebkitFontSmoothing: 'antialiased',
    MozOsxFontSmoothing: 'grayscale',
    lineHeight: '18px',
    padding: '11px 1rem',
    whiteSpace: 'pre-wrap',
    color: 'inherit',
    borderRadius: 3,
    margin: '1rem 0',
    '&:not(.hljs)': {
      background: 'transparent',
      border: 'none',
      borderRadius: 0,
      padding: 0,
      margin: 0
    },
    '& pre, &.hljs': {
      padding: 15,
      margin: 0,
      whiteSpace: 'pre-wrap',
      color: 'inherit',
      fontSize: '13px',
      lineHeight: '19px',
      code: {
        color: 'inherit',
        fontSize: 'inherit'
      }
    },
    '& code': {
      whiteSpace: 'pre'
    },
    '& code, & tt': {
      border: 'none'
    }
  };
});

exports.Pre = Pre;

var A = _theming.styled.a(_withReset.withReset, function (_ref9) {
  var theme = _ref9.theme;
  return {
    fontSize: theme.typography.size.s2,
    lineHeight: '24px',
    color: "".concat(theme.color.secondary),
    textDecoration: 'none',
    '&.absent': {
      color: '#cc0000'
    },
    '&.anchor': {
      display: 'block',
      paddingLeft: '30px',
      marginLeft: '-30px',
      cursor: 'pointer',
      position: 'absolute',
      top: '0',
      left: '0',
      bottom: '0'
    }
  };
});

exports.A = A;

var HR = _theming.styled.hr(function (_ref10) {
  var theme = _ref10.theme;
  return {
    border: '0 none',
    color: theme.appBorderColor,
    height: '4px',
    padding: '0'
  };
});

exports.HR = HR;

var DL = _theming.styled.dl(_withReset.withReset, Object.assign({}, withMargin, {
  padding: 0,
  '& dt': {
    fontSize: '14px',
    fontWeight: 'bold',
    fontStyle: 'italic',
    padding: 0,
    margin: '16px 0 4px'
  },
  '& dt:first-of-type': {
    padding: 0
  },
  '& dt > :first-of-type': {
    marginTop: 0
  },
  '& dt > :last-child': {
    marginBottom: 0
  },
  '& dd': {
    margin: '0 0 16px',
    padding: '0 15px'
  },
  '& dd > :first-of-type': {
    marginTop: 0
  },
  '& dd > :last-child': {
    marginBottom: 0
  }
}));

exports.DL = DL;

var Blockquote = _theming.styled.blockquote(_withReset.withReset, withMargin, function (_ref11) {
  var theme = _ref11.theme;
  return {
    borderLeft: "4px solid ".concat(theme.color.medium),
    padding: '0 15px',
    color: theme.color.dark,
    '& > :first-of-type': {
      marginTop: '0'
    },
    '& > :last-child': {
      marginBottom: 0
    }
  };
});

exports.Blockquote = Blockquote;

var Table = _theming.styled.table(_withReset.withReset, withMargin, function (_ref12) {
  var theme = _ref12.theme;
  return {
    fontSize: theme.typography.size.s2,
    lineHeight: '24px',
    padding: 0,
    borderCollapse: 'collapse',
    '& tr': {
      borderTop: "1px solid ".concat(theme.appBorderColor),
      backgroundColor: 'white',
      margin: '0',
      padding: '0'
    },
    '& tr:nth-of-type(2n)': {
      backgroundColor: "".concat(theme.color.lighter)
    },
    '& tr th': {
      fontWeight: 'bold',
      border: "1px solid ".concat(theme.appBorderColor),
      textAlign: 'left',
      margin: '0',
      padding: '6px 13px'
    },
    '& tr td': {
      border: "1px solid ".concat(theme.appBorderColor),
      textAlign: 'left',
      margin: '0',
      padding: '6px 13px'
    },
    '& tr th :first-of-type, & tr td :first-of-type': {
      marginTop: '0'
    },
    '& tr th :last-child, & tr td :last-child': {
      marginBottom: '0'
    }
  };
});

exports.Table = Table;

var Img = _theming.styled.img({
  maxWidth: '100%'
});

exports.Img = Img;

var Div = _theming.styled.div(_withReset.withReset);

exports.Div = Div;

var Span = _theming.styled.span(_withReset.withReset, function (_ref13) {
  var theme = _ref13.theme;
  return {
    '&.frame': {
      display: 'block',
      overflow: 'hidden'
    },
    '&.frame > span': {
      border: "1px solid ".concat(theme.color.medium),
      display: 'block',
      "float": 'left',
      overflow: 'hidden',
      margin: '13px 0 0',
      padding: '7px',
      width: 'auto'
    },
    '&.frame span img': {
      display: 'block',
      "float": 'left'
    },
    '&.frame span span': {
      clear: 'both',
      color: theme.color.darkest,
      display: 'block',
      padding: '5px 0 0'
    },
    '&.align-center': {
      display: 'block',
      overflow: 'hidden',
      clear: 'both'
    },
    '&.align-center > span': {
      display: 'block',
      overflow: 'hidden',
      margin: '13px auto 0',
      textAlign: 'center'
    },
    '&.align-center span img': {
      margin: '0 auto',
      textAlign: 'center'
    },
    '&.align-right': {
      display: 'block',
      overflow: 'hidden',
      clear: 'both'
    },
    '&.align-right > span': {
      display: 'block',
      overflow: 'hidden',
      margin: '13px 0 0',
      textAlign: 'right'
    },
    '&.align-right span img': {
      margin: '0',
      textAlign: 'right'
    },
    '&.float-left': {
      display: 'block',
      marginRight: '13px',
      overflow: 'hidden',
      "float": 'left'
    },
    '&.float-left span': {
      margin: '13px 0 0'
    },
    '&.float-right': {
      display: 'block',
      marginLeft: '13px',
      overflow: 'hidden',
      "float": 'right'
    },
    '&.float-right > span': {
      display: 'block',
      overflow: 'hidden',
      margin: '13px auto 0',
      textAlign: 'right'
    }
  };
});

exports.Span = Span;
var listCommon = {
  paddingLeft: '30px',
  '& :first-of-type': {
    marginTop: 0
  },
  '& :last-child': {
    marginBottom: 0
  }
};

var LI = _theming.styled.li(_withReset.withReset, function (_ref14) {
  var theme = _ref14.theme;
  return {
    fontSize: theme.typography.size.s2,
    color: theme.color.defaultText,
    lineHeight: '24px',
    '& + li': {
      marginTop: '.25em'
    },
    '& ul, & ol': {
      marginTop: '.25em',
      marginBottom: 0
    },
    '& code': codeCommon({
      theme: theme
    })
  };
});

exports.LI = LI;

var UL = _theming.styled.ul(_withReset.withReset, withMargin, listCommon, {});

exports.UL = UL;

var OL = _theming.styled.ol(_withReset.withReset, withMargin, listCommon);

exports.OL = OL;

var codeCommon = function codeCommon(_ref15) {
  var theme = _ref15.theme;
  return {
    margin: '0 2px',
    padding: '0 5px',
    whiteSpace: 'nowrap',
    border: "1px solid ".concat(theme.color.mediumlight),
    backgroundColor: theme.color.lighter,
    borderRadius: '3px',
    fontSize: theme.typography.size.s2 - 1,
    color: theme.base === 'dark' && theme.color.darkest
  };
};

var P = _theming.styled.p(_withReset.withReset, withMargin, function (_ref16) {
  var theme = _ref16.theme;
  return {
    fontSize: theme.typography.size.s2,
    lineHeight: '24px',
    color: theme.color.defaultText,
    '& code': codeCommon({
      theme: theme
    })
  };
});

exports.P = P;

var Code = _theming.styled.code(function (_ref17) {
  var theme = _ref17.theme;
  return {
    // from reset
    fontFamily: theme.typography.fonts.mono,
    WebkitFontSmoothing: 'antialiased',
    MozOsxFontSmoothing: 'grayscale',
    display: 'inline-block',
    paddingLeft: 2,
    paddingRight: 2,
    verticalAlign: 'baseline',
    color: 'inherit'
  };
}, codeCommon);

exports.Code = Code;

var TT = _theming.styled.title(codeCommon);
/**
 * This is a "local" reset to style subtrees with Storybook styles
 *
 * We can't style individual elements (e.g. h1, h2, etc.) in here
 * because the CSS specificity is too high, so those styles can too
 * easily override child elements that are not expecting it.
 */


exports.TT = TT;

var ResetWrapper = _theming.styled.div(_withReset.withReset);

exports.ResetWrapper = ResetWrapper;