"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.keys");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _theming = require("@storybook/theming");

var _components = require("@storybook/components");

var _SidebarHeading = _interopRequireDefault(require("./SidebarHeading"));

var _SidebarStories = _interopRequireDefault(require("./SidebarStories"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var Heading = (0, _theming.styled)(_SidebarHeading["default"])({
  padding: '20px 20px 12px'
});
var Stories = (0, _theming.styled)(function (_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["className"]);

  return _react["default"].createElement(_SidebarStories["default"], _extends({
    className: className
  }, rest));
})(function (_ref2) {
  var loading = _ref2.loading;
  return loading ? {
    marginTop: 8
  } : {};
});

var Container = _theming.styled.nav({
  position: 'absolute',
  zIndex: 1,
  left: 0,
  top: 0,
  bottom: 0,
  right: 0,
  width: '100%',
  height: '100%'
});

var CustomScrollArea = (0, _theming.styled)(_components.ScrollArea)({
  '.simplebar-track.simplebar-vertical': {
    right: '4px'
  }
});

var Sidebar = function Sidebar(_ref3) {
  var storyId = _ref3.storyId,
      stories = _ref3.stories,
      menu = _ref3.menu,
      _ref3$menuHighlighted = _ref3.menuHighlighted,
      menuHighlighted = _ref3$menuHighlighted === void 0 ? false : _ref3$menuHighlighted,
      _ref3$loading = _ref3.loading,
      loading = _ref3$loading === void 0 ? false : _ref3$loading;
  return _react["default"].createElement(Container, {
    className: "container sidebar-container"
  }, _react["default"].createElement(CustomScrollArea, {
    vertical: true
  }, _react["default"].createElement(Heading, {
    className: "sidebar-header",
    menuHighlighted: menuHighlighted,
    menu: menu
  }), _react["default"].createElement(Stories, {
    stories: stories,
    storyId: storyId,
    loading: loading
  })));
};

Sidebar.displayName = "Sidebar";
var _default = Sidebar;
exports["default"] = _default;