'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = _interopDefault(require('react'));
var Vue = _interopDefault(require('vue'));

var defaultPassProps = function defaultPassProps(props) {
  return props;
};

var index = (function (Component) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref$passProps = _ref.passProps,
      passProps = _ref$passProps === void 0 ? defaultPassProps : _ref$passProps;

  return function (props) {
    var el = React.useRef(null);
    React.useEffect(function () {
      var app = new Vue({
        el: el.current,
        render: function render(h) {
          return h(Component, {
            props: passProps ? passProps(props) : {}
          });
        }
      });
      return function () {
        return app.$destroy();
      };
    });
    return React.createElement('div', null, React.createElement('div', {
      ref: el
    }));
  };
});

module.exports = index;
