"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseTheme = void 0;

var _chart_global_FontFamily = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_FontFamily"));

var _chart_global_letter_spacing = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_letter_spacing"));

var _chart_global_FontSize_sm = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_FontSize_sm"));

var _chart_global_label_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_Padding"));

var _chart_global_label_stroke = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_stroke"));

var _chart_global_label_text_anchor = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_text_anchor"));

var _chart_global_layout_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Padding"));

var _chart_global_layout_Height = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Height"));

var _chart_global_layout_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Width"));

var _chart_global_stroke_line_cap = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_stroke_line_cap"));

var _chart_global_stroke_line_join = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_global_stroke_line_join"));

var _chart_area_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_area_data_Fill"));

var _chart_area_Opacity = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_area_Opacity"));

var _chart_area_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_area_stroke_Width"));

var _chart_axis_axis_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_stroke_Width"));

var _chart_axis_axis_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_stroke_Color"));

var _chart_axis_axis_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_Fill"));

var _chart_axis_axis_label_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_label_Padding"));

var _chart_axis_axis_label_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_label_stroke_Color"));

var _chart_axis_grid_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_grid_Fill"));

var _chart_axis_grid_PointerEvents = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_grid_PointerEvents"));

var _chart_axis_tick_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Fill"));

var _chart_axis_tick_Size = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Size"));

var _chart_axis_tick_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_stroke_Color"));

var _chart_axis_tick_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Width"));

var _chart_axis_tick_label_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_label_Fill"));

var _chart_bar_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bar_Width"));

var _chart_bar_data_stroke = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_stroke"));

var _chart_bar_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_Fill"));

var _chart_bar_data_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_Padding"));

var _chart_bar_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_stroke_Width"));

var _chart_boxplot_max_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_Padding"));

var _chart_boxplot_max_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_stroke_Color"));

var _chart_boxplot_max_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_stroke_Width"));

var _chart_boxplot_median_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_Padding"));

var _chart_boxplot_median_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_stroke_Color"));

var _chart_boxplot_median_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_stroke_Width"));

var _chart_boxplot_min_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_Padding"));

var _chart_boxplot_min_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_stroke_Width"));

var _chart_boxplot_min_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_stroke_Color"));

var _chart_boxplot_lower_quartile_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_lower_quartile_Padding"));

var _chart_boxplot_lower_quartile_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_lower_quartile_Fill"));

var _chart_boxplot_upper_quartile_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_upper_quartile_Padding"));

var _chart_boxplot_upper_quartile_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_upper_quartile_Fill"));

var _chart_boxplot_box_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_box_Width"));

var _chart_candelstick_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_data_stroke_Width"));

var _chart_candelstick_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_data_stroke_Color"));

var _chart_candelstick_candle_positive_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_candle_positive_Color"));

var _chart_candelstick_candle_negative_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_candle_negative_Color"));

var _chart_errorbar_BorderWidth = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_BorderWidth"));

var _chart_errorbar_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_Fill"));

var _chart_errorbar_data_Opacity = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_Opacity"));

var _chart_errorbar_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_stroke_Width"));

var _chart_errorbar_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_stroke_Color"));

var _chart_legend_gutter_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_legend_gutter_Width"));

var _chart_legend_orientation = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_legend_orientation"));

var _chart_legend_title_orientation = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_legend_title_orientation"));

var _chart_legend_data_type = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_legend_data_type"));

var _chart_legend_title_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_legend_title_Padding"));

var _chart_line_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_Fill"));

var _chart_line_data_Opacity = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_Opacity"));

var _chart_line_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_stroke_Width"));

var _chart_line_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_stroke_Color"));

var _chart_pie_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Padding"));

var _chart_pie_data_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_Padding"));

var _chart_pie_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_stroke_Width"));

var _chart_pie_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_stroke_Color"));

var _chart_pie_labels_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_labels_Padding"));

var _chart_pie_Height = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Height"));

var _chart_pie_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Width"));

var _chart_scatter_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_stroke_Color"));

var _chart_scatter_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_stroke_Width"));

var _chart_scatter_data_Opacity = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_Opacity"));

var _chart_scatter_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_Fill"));

var _chart_stack_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_stack_data_stroke_Width"));

var _chart_tooltip_corner_radius = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_corner_radius"));

var _chart_tooltip_pointer_length = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_pointer_length"));

var _chart_tooltip_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_Fill"));

var _chart_tooltip_flyoutStyle_corner_radius = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_corner_radius"));

var _chart_tooltip_flyoutStyle_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_stroke_Width"));

var _chart_tooltip_flyoutStyle_PointerEvents = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_PointerEvents"));

var _chart_tooltip_flyoutStyle_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_stroke_Color"));

var _chart_tooltip_flyoutStyle_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_Fill"));

var _chart_tooltip_pointer_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_pointer_Width"));

var _chart_tooltip_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_Padding"));

var _chart_tooltip_PointerEvents = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_PointerEvents"));

var _chart_voronoi_data_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_Fill"));

var _chart_voronoi_data_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_stroke_Color"));

var _chart_voronoi_data_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_stroke_Width"));

var _chart_voronoi_labels_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_Fill"));

var _chart_voronoi_labels_Padding = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_Padding"));

var _chart_voronoi_labels_PointerEvents = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_PointerEvents"));

var _chart_voronoi_flyout_stroke_Width = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Width"));

var _chart_voronoi_flyout_PointerEvents = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_PointerEvents"));

var _chart_voronoi_flyout_stroke_Color = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Color"));

var _chart_voronoi_flyout_stroke_Fill = _interopRequireDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Fill"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Note: Values must be in pixles
// Typography
var TYPOGRAPHY_FONT_FAMILY = _chart_global_FontFamily["default"]["var"];
var TYPOGRAPHY_LETTER_SPACING = _chart_global_letter_spacing["default"]["var"];
var TYPOGRAPHY_FONT_SIZE = _chart_global_FontSize_sm["default"].value; // Labels

var LABEL_PROPS = {
  fontFamily: TYPOGRAPHY_FONT_FAMILY,
  fontSize: TYPOGRAPHY_FONT_SIZE,
  letterSpacing: TYPOGRAPHY_LETTER_SPACING,
  padding: _chart_global_label_Padding["default"].value,
  stroke: _chart_global_label_stroke["default"].value
};

var LABEL_CENTERED_PROPS = _objectSpread({}, LABEL_PROPS, {
  textAnchor: _chart_global_label_text_anchor["default"].value
}); // Layout


var LAYOUT_PROPS = {
  padding: _chart_global_layout_Padding["default"].value,
  height: _chart_global_layout_Height["default"].value,
  width: _chart_global_layout_Width["default"].value
}; // Strokes

var STROKE_LINE_CAP = _chart_global_stroke_line_cap["default"].value;
var STROKE_LINE_JOIN = _chart_global_stroke_line_join["default"].value; // Victory theme properties only

var BaseTheme = {
  area: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      data: {
        fill: _chart_area_data_Fill["default"].value,
        fillOpacity: _chart_area_Opacity["default"].value,
        // Omit stroke to add a line border from color scale
        // stroke: chart_global_label_stroke.value,
        strokeWidth: _chart_area_stroke_Width["default"].value
      },
      labels: LABEL_CENTERED_PROPS
    }
  }),
  axis: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      axis: {
        fill: _chart_axis_axis_Fill["default"].value,
        strokeWidth: _chart_axis_axis_stroke_Width["default"].value,
        stroke: _chart_axis_axis_stroke_Color["default"].value,
        strokeLinecap: STROKE_LINE_CAP,
        strokeLinejoin: STROKE_LINE_JOIN
      },
      axisLabel: _objectSpread({}, LABEL_CENTERED_PROPS, {
        padding: _chart_axis_axis_label_Padding["default"].value,
        stroke: _chart_axis_axis_label_stroke_Color["default"].value
      }),
      grid: {
        fill: _chart_axis_grid_Fill["default"].value,
        stroke: 'none',
        pointerEvents: _chart_axis_grid_PointerEvents["default"].value,
        strokeLinecap: STROKE_LINE_CAP,
        strokeLinejoin: STROKE_LINE_JOIN
      },
      ticks: {
        fill: _chart_axis_tick_Fill["default"].value,
        size: _chart_axis_tick_Size["default"].value,
        stroke: _chart_axis_tick_stroke_Color["default"].value,
        strokeLinecap: STROKE_LINE_CAP,
        strokeLinejoin: STROKE_LINE_JOIN,
        strokeWidth: _chart_axis_tick_Width["default"].value
      },
      tickLabels: _objectSpread({}, LABEL_PROPS, {
        fill: _chart_axis_tick_label_Fill["default"].value
      })
    }
  }),
  bar: _objectSpread({}, LAYOUT_PROPS, {
    barWidth: _chart_bar_Width["default"].value,
    style: {
      data: {
        fill: _chart_bar_data_Fill["default"].value,
        padding: _chart_bar_data_Padding["default"].value,
        stroke: _chart_bar_data_stroke["default"].value,
        strokeWidth: _chart_bar_data_stroke_Width["default"].value
      },
      labels: LABEL_PROPS
    }
  }),
  boxplot: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      max: {
        padding: _chart_boxplot_max_Padding["default"].value,
        stroke: _chart_boxplot_max_stroke_Color["default"].value,
        strokeWidth: _chart_boxplot_max_stroke_Width["default"].value
      },
      maxLabels: LABEL_PROPS,
      median: {
        padding: _chart_boxplot_median_Padding["default"].value,
        stroke: _chart_boxplot_median_stroke_Color["default"].value,
        strokeWidth: _chart_boxplot_median_stroke_Width["default"].value
      },
      medianLabels: LABEL_PROPS,
      min: {
        padding: _chart_boxplot_min_Padding["default"].value,
        stroke: _chart_boxplot_min_stroke_Color["default"].value,
        strokeWidth: _chart_boxplot_min_stroke_Width["default"].value
      },
      minLabels: LABEL_PROPS,
      q1: {
        fill: _chart_boxplot_lower_quartile_Fill["default"].value,
        padding: _chart_boxplot_lower_quartile_Padding["default"].value
      },
      q1Labels: LABEL_PROPS,
      q3: {
        fill: _chart_boxplot_upper_quartile_Fill["default"].value,
        padding: _chart_boxplot_upper_quartile_Padding["default"].value
      },
      q3Labels: LABEL_PROPS
    },
    boxWidth: _chart_boxplot_box_Width["default"].value
  }),
  candlestick: _objectSpread({}, LAYOUT_PROPS, {
    candleColors: {
      positive: _chart_candelstick_candle_positive_Color["default"].value,
      negative: _chart_candelstick_candle_negative_Color["default"].value
    },
    style: {
      data: {
        stroke: _chart_candelstick_data_stroke_Color["default"].value,
        strokeWidth: _chart_candelstick_data_stroke_Width["default"].value
      },
      labels: LABEL_CENTERED_PROPS
    }
  }),
  chart: _objectSpread({}, LAYOUT_PROPS),
  errorbar: _objectSpread({}, LAYOUT_PROPS, {
    borderWidth: _chart_errorbar_BorderWidth["default"].value,
    style: {
      data: {
        fill: _chart_errorbar_data_Fill["default"].value,
        opacity: _chart_errorbar_data_Opacity["default"].value,
        stroke: _chart_errorbar_data_stroke_Color["default"].value,
        strokeWidth: _chart_errorbar_data_stroke_Width["default"].value
      },
      labels: LABEL_CENTERED_PROPS
    }
  }),
  group: _objectSpread({}, LAYOUT_PROPS),
  legend: {
    gutter: _chart_legend_gutter_Width["default"].value,
    orientation: _chart_legend_orientation["default"].value,
    titleOrientation: _chart_legend_title_orientation["default"].value,
    style: {
      data: {
        type: _chart_legend_data_type["default"].value
      },
      labels: LABEL_PROPS,
      title: _objectSpread({}, LABEL_PROPS, {
        fontSize: TYPOGRAPHY_FONT_SIZE,
        padding: _chart_legend_title_Padding["default"].value
      })
    }
  },
  line: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      data: {
        fill: _chart_line_data_Fill["default"].value,
        opacity: _chart_line_data_Opacity["default"].value,
        stroke: _chart_line_data_stroke_Color["default"].value,
        strokeWidth: _chart_line_data_stroke_Width["default"].value
      },
      labels: LABEL_CENTERED_PROPS
    }
  }),
  pie: {
    padding: _chart_pie_Padding["default"].value,
    style: {
      data: {
        padding: _chart_pie_data_Padding["default"].value,
        stroke: _chart_pie_data_stroke_Color["default"].value,
        strokeWidth: _chart_pie_data_stroke_Width["default"].value
      },
      labels: _objectSpread({}, LABEL_PROPS, {
        padding: _chart_pie_labels_Padding["default"].value
      })
    },
    height: _chart_pie_Height["default"].value,
    width: _chart_pie_Width["default"].value
  },
  scatter: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      data: {
        fill: _chart_scatter_data_Fill["default"].value,
        opacity: _chart_scatter_data_Opacity["default"].value,
        stroke: _chart_scatter_data_stroke_Color["default"].value,
        strokeWidth: _chart_scatter_data_stroke_Width["default"].value
      },
      labels: LABEL_CENTERED_PROPS
    }
  }),
  stack: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      data: {
        strokeWidth: _chart_stack_data_stroke_Width["default"].value
      }
    }
  }),
  tooltip: {
    cornerRadius: _chart_tooltip_corner_radius["default"].value,
    flyoutStyle: {
      cornerRadius: _chart_tooltip_flyoutStyle_corner_radius["default"].value,
      fill: _chart_tooltip_flyoutStyle_Fill["default"].value,
      // background
      pointerEvents: _chart_tooltip_flyoutStyle_PointerEvents["default"].value,
      stroke: _chart_tooltip_flyoutStyle_stroke_Color["default"].value,
      // border
      strokeWidth: _chart_tooltip_flyoutStyle_stroke_Width["default"].value
    },
    pointerLength: _chart_tooltip_pointer_length["default"].value,
    pointerWidth: _chart_tooltip_pointer_Width["default"].value,
    style: {
      fill: _chart_tooltip_Fill["default"].value,
      // text
      padding: _chart_tooltip_Padding["default"].value,
      pointerEvents: _chart_tooltip_PointerEvents["default"].value
    }
  },
  voronoi: _objectSpread({}, LAYOUT_PROPS, {
    style: {
      data: {
        fill: _chart_voronoi_data_Fill["default"].value,
        stroke: _chart_voronoi_data_stroke_Color["default"].value,
        strokeWidth: _chart_voronoi_data_stroke_Width["default"].value
      },
      labels: _objectSpread({}, LABEL_CENTERED_PROPS, {
        fill: _chart_voronoi_labels_Fill["default"].value,
        // text
        padding: _chart_voronoi_labels_Padding["default"].value,
        pointerEvents: _chart_voronoi_labels_PointerEvents["default"].value
      }),
      // Note: These properties override tooltip
      flyout: {
        fill: _chart_voronoi_flyout_stroke_Fill["default"].value,
        // background
        pointerEvents: _chart_voronoi_flyout_PointerEvents["default"].value,
        stroke: _chart_voronoi_flyout_stroke_Color["default"].value,
        // border
        strokeWidth: _chart_voronoi_flyout_stroke_Width["default"].value
      }
    }
  })
};
exports.BaseTheme = BaseTheme;
//# sourceMappingURL=base-theme.js.map