import { PaddingProps } from 'victory';
import { ChartLegendProps } from '../ChartLegend';
import { ChartThemeDefinition } from '../ChartTheme';
import * as React from 'react';
interface ChartLegendInterface {
    allowWrap?: boolean;
    chartType?: string;
    dx?: number;
    dy?: number;
    height: number;
    legendComponent: React.ReactElement<any>;
    orientation?: 'horizontal' | 'vertical';
    padding: PaddingProps;
    position: 'bottom' | 'bottom-left' | 'right';
    theme: ChartThemeDefinition;
    width: number;
}
interface ChartLegendDimensionsInterface {
    legendData: any[];
    legendOrientation: 'horizontal' | 'vertical';
    legendProps: ChartLegendProps;
    theme: ChartThemeDefinition;
}
interface ChartLegendPositionInterface {
    chartType?: string;
    dx?: number;
    dy?: number;
    height?: number;
    legendData: any[];
    legendOrientation: 'horizontal' | 'vertical';
    legendPosition: 'bottom' | 'bottom-left' | 'right';
    legendProps: any;
    padding?: PaddingProps;
    theme: ChartThemeDefinition;
    width?: number;
}
export declare const getComputedLegend: ({ allowWrap, chartType, dx, dy, height, legendComponent, padding, position, theme, width, orientation }: ChartLegendInterface) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)>) | (new (props: any) => React.Component<any, any, any>)>;
export declare const getLegendDimensions: ({ legendData, legendOrientation, legendProps, theme }: ChartLegendDimensionsInterface) => any;
export declare const doesLegendFit: ({ dx, height, legendPosition, legendData, legendOrientation, legendProps, padding, theme, width }: ChartLegendPositionInterface) => boolean;
export declare const getLegendItemsPerRow: ({ dx, height, legendPosition, legendData, legendOrientation, legendProps, padding, theme, width }: ChartLegendPositionInterface) => number;
export declare const getLegendX: ({ chartType, ...rest }: ChartLegendPositionInterface) => any;
export declare const getLegendY: ({ chartType, ...rest }: ChartLegendPositionInterface) => any;
export declare const getBulletLegendY: ({ dy, height, legendPosition, legendData, legendOrientation, legendProps, padding, theme, width }: ChartLegendPositionInterface) => number;
export declare const getChartLegendX: ({ dx, height, legendData, legendOrientation, legendPosition, legendProps, padding, theme, width }: ChartLegendPositionInterface) => any;
export declare const getChartLegendY: ({ dy, height, legendPosition, legendData, legendOrientation, legendProps, padding, theme, width }: ChartLegendPositionInterface) => any;
export declare const getPieLegendX: ({ dx, height, legendData, legendOrientation, legendPosition, legendProps, padding, theme, width }: ChartLegendPositionInterface) => any;
export declare const getPieLegendY: ({ dy, height, legendPosition, legendData, legendOrientation, legendProps, padding, theme, width }: ChartLegendPositionInterface) => any;
export {};
