/*
 * Copyright 2020, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

package io.enmasse.iot.model.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;

@Buildable(
        editableEnabled = false,
        generateBuilderPackage = false,
        refs = {@BuildableReference(ResourceRequirements.class)},
        builderPackage = "io.fabric8.kubernetes.api.builder",
        inline = @Inline(
                type = Doneable.class,
                prefix = "Doneable",
                value = "done"))
@JsonInclude(JsonInclude.Include.NON_NULL)
public class JavaContainerConfig {

    private Boolean requireNativeTls;
    private LogbackConfig logback;

    @JsonUnwrapped
    private ContainerConfig containerConfig;

    public Boolean getRequireNativeTls() {
        return requireNativeTls;
    }

    public void setRequireNativeTls(Boolean requireNativeTls) {
        this.requireNativeTls = requireNativeTls;
    }

    public LogbackConfig getLogback() {
        return logback;
    }

    public void setLogback(LogbackConfig logback) {
        this.logback = logback;
    }

    public ContainerConfig getContainerConfig() {
        return containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

}
