#!/usr/bin/env bash

# Generates documentation/book/ref-kafka-versions.adoc
# according to the values in kafka-versions

. $(dirname $0)/../multi-platform-support.sh

FILE=$1
cat <<EOF
// This assembly is included in the following assemblies:
//
// assembly-upgrading-kafka-versions.adoc
// Generated by documentation/supported-version.sh during the build
// DO NOT EDIT BY HAND
[options="header"]
|=================
|Kafka version |Interbroker protocol version |Log message format version| Zookeeper version
EOF
for x in $($GREP -E '^[^#]' "$FILE" | $SED -E 's/ +/|/g'); do
    
    for y in $(echo $x | $SED -E -e 's/[|]default//g' | cut -d "|" -f 1,2,3 | $SED -E -e 's/[|]/ /g' ); do
        echo -n "|$y "
    done
    echo "|3.4.13"
done
cat <<EOF
|=================
EOF
