/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.matchers;

import io.fabric8.kubernetes.api.model.Event;
import io.strimzi.systemtest.k8s.Events;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class HasAllOfReasons
extends BaseMatcher<List<Event>> {
    private Events[] eventReasons;

    public HasAllOfReasons(Events ... eventReasons) {
        this.eventReasons = eventReasons;
    }

    public boolean matches(Object actualValue) {
        List actualReasons = ((List)actualValue).stream().map(Event::getReason).collect(Collectors.toList());
        List expectedReasons = Arrays.stream(this.eventReasons).map(Enum::name).collect(Collectors.toList());
        return actualReasons.containsAll(expectedReasons);
    }

    public void describeTo(Description description) {
        description.appendValueList("The resource should contain all of the following events {", ", ", "}. ", (Object[])this.eventReasons);
    }
}

