/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaBridgeResources;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectResources;
import io.strimzi.api.kafka.model.KafkaConnectS2I;
import io.strimzi.api.kafka.model.KafkaConnectS2IResources;
import io.strimzi.api.kafka.model.KafkaExporterResources;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Resources;
import io.strimzi.api.kafka.model.KafkaMirrorMakerResources;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.api.kafka.model.Spec;
import io.strimzi.api.kafka.model.status.Condition;
import io.strimzi.api.kafka.model.status.Status;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.utils.kafkaUtils.KafkaTopicUtils;
import io.strimzi.systemtest.utils.kafkaUtils.KafkaUserUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.ConfigMapUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentConfigUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.ReplicaSetUtils;
import io.strimzi.systemtest.utils.kubeUtils.controllers.StatefulSetUtils;
import io.strimzi.systemtest.utils.kubeUtils.objects.PersistentVolumeClaimUtils;
import io.strimzi.systemtest.utils.kubeUtils.objects.PodUtils;
import io.strimzi.systemtest.utils.kubeUtils.objects.SecretUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.HelmClient;
import io.strimzi.test.k8s.KubeClient;
import io.strimzi.test.k8s.KubeClusterResource;
import io.strimzi.test.k8s.cmdClient.KubeCmdClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final Logger LOGGER = LogManager.getLogger(ResourceManager.class);
    public static final String STRIMZI_PATH_TO_CO_CONFIG = TestUtils.USER_PATH + "/../install/cluster-operator/060-Deployment-strimzi-cluster-operator.yaml";
    public static final long CR_CREATION_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness();
    private static Stack<Runnable> classResources = new Stack();
    private static Stack<Runnable> methodResources = new Stack();
    private static Stack<Runnable> pointerResources = classResources;
    private static String coDeploymentName = "strimzi-cluster-operator";

    private ResourceManager() {
    }

    public static KubeClient kubeClient() {
        return KubeClusterResource.kubeClient();
    }

    public static KubeCmdClient cmdKubeClient() {
        return KubeClusterResource.cmdKubeClient();
    }

    public static HelmClient helmClient() {
        return KubeClusterResource.helmClusterClient();
    }

    public static Stack<Runnable> getPointerResources() {
        return pointerResources;
    }

    public static void setMethodResources() {
        LOGGER.info("Setting pointer to method resources");
        pointerResources = methodResources;
    }

    public static void setClassResources() {
        LOGGER.info("Setting pointer to class resources");
        pointerResources = classResources;
    }

    public static <T extends CustomResource, L extends CustomResourceList<T>> void replaceCrdResource(Class<T> crdClass, Class<L> listClass, String resourceName, Consumer<T> editor) {
        Resource namedResource = (Resource)((NonNamespaceOperation)Crds.operation((KubernetesClient)ResourceManager.kubeClient().getClient(), crdClass, listClass).inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName);
        CustomResource resource = (CustomResource)namedResource.get();
        editor.accept(resource);
        namedResource.replace((Object)resource);
    }

    public static <T extends HasMetadata> T deleteLater(MixedOperation<T, ?, ?> operation, T resource) {
        LOGGER.debug("Scheduled deletion of {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)(resource.getMetadata().getNamespace() == null ? "(not set)" : resource.getMetadata().getNamespace()));
        switch (resource.getKind()) {
            case "Kafka": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((Kafka)resource);
                });
                break;
            }
            case "KafkaConnect": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((KafkaConnect)resource);
                });
                break;
            }
            case "KafkaConnectS2I": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((KafkaConnectS2I)resource);
                });
                break;
            }
            case "KafkaMirrorMaker": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((KafkaMirrorMaker)resource);
                });
                break;
            }
            case "KafkaMirrorMaker2": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((KafkaMirrorMaker2)resource);
                });
                break;
            }
            case "KafkaBridge": {
                pointerResources.add(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.waitForDeletion((KafkaBridge)resource);
                });
                break;
            }
            case "KafkaTopic": {
                pointerResources.add(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    KafkaTopicUtils.waitForKafkaTopicDeletion(resource.getMetadata().getName());
                });
                break;
            }
            case "KafkaUser": {
                pointerResources.add(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    KafkaUserUtils.waitForKafkaUserDeletion(resource.getMetadata().getName());
                });
                break;
            }
            case "Deployment": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName());
                    ResourceManager.waitForDeletion((Deployment)resource);
                });
                break;
            }
            case "ClusterRoleBinding": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName());
                    ((Resource)ResourceManager.kubeClient().getClient().rbac().clusterRoleBindings().withName(resource.getMetadata().getName())).delete();
                });
                break;
            }
            case "RoleBinding": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName());
                    ((Resource)((NonNamespaceOperation)ResourceManager.kubeClient().getClient().rbac().roleBindings().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
                });
                break;
            }
            case "Service": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((ServiceResource)((NonNamespaceOperation)ResourceManager.kubeClient().getClient().services().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
                });
                break;
            }
            case "Ingress": {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                    ResourceManager.kubeClient().deleteIngress((Ingress)resource);
                });
                break;
            }
            default: {
                pointerResources.push(() -> {
                    LOGGER.info("Deleting {} {} in namespace {}", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace());
                    ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)operation.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
                });
            }
        }
        return resource;
    }

    private static void waitForDeletion(Kafka kafka) {
        String kafkaClusterName = kafka.getMetadata().getName();
        LOGGER.info("Waiting when all the pods are terminated for Kafka {}", (Object)kafkaClusterName);
        StatefulSetUtils.waitForStatefulSetDeletion(KafkaResources.zookeeperStatefulSetName((String)kafkaClusterName));
        IntStream.rangeClosed(0, kafka.getSpec().getZookeeper().getReplicas() - 1).forEach(podIndex -> PodUtils.deletePodWithWait(KafkaResources.zookeeperPodName((String)kafka.getMetadata().getName(), (int)podIndex)));
        StatefulSetUtils.waitForStatefulSetDeletion(KafkaResources.kafkaStatefulSetName((String)kafkaClusterName));
        IntStream.rangeClosed(0, kafka.getSpec().getKafka().getReplicas() - 1).forEach(podIndex -> PodUtils.deletePodWithWait(KafkaResources.kafkaPodName((String)kafka.getMetadata().getName(), (int)podIndex)));
        DeploymentUtils.waitForDeploymentDeletion(KafkaResources.entityOperatorDeploymentName((String)kafkaClusterName));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaResources.entityOperatorDeploymentName((String)kafkaClusterName));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().contains(KafkaResources.entityOperatorDeploymentName((String)kafka.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
        DeploymentUtils.waitForDeploymentDeletion(KafkaExporterResources.deploymentName((String)kafkaClusterName));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaExporterResources.deploymentName((String)kafkaClusterName));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().contains(KafkaExporterResources.deploymentName((String)kafka.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
        SecretUtils.waitForClusterSecretsDeletion(kafkaClusterName);
        PersistentVolumeClaimUtils.waitUntilPVCDeletion(kafkaClusterName);
        ConfigMapUtils.waitUntilConfigMapDeletion(KafkaResources.kafkaMetricsAndLogConfigMapName((String)kafka.getMetadata().getName()));
        ConfigMapUtils.waitUntilConfigMapDeletion(KafkaResources.zookeeperMetricsAndLogConfigMapName((String)kafka.getMetadata().getName()));
    }

    private static void waitForDeletion(KafkaConnect kafkaConnect) {
        LOGGER.info("Waiting when all the Pods are terminated for KafkaConnect {}", (Object)kafkaConnect.getMetadata().getName());
        DeploymentUtils.waitForDeploymentDeletion(KafkaConnectResources.deploymentName((String)kafkaConnect.getMetadata().getName()));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaConnectResources.deploymentName((String)kafkaConnect.getMetadata().getName()));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(KafkaConnectResources.deploymentName((String)kafkaConnect.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    private static void waitForDeletion(KafkaConnectS2I kafkaConnectS2I) {
        LOGGER.info("Waiting when all the Pods are terminated for KafkaConnectS2I {}", (Object)kafkaConnectS2I.getMetadata().getName());
        DeploymentConfigUtils.waitForDeploymentConfigDeletion(KafkaConnectS2IResources.deploymentName((String)kafkaConnectS2I.getMetadata().getName()));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaConnectS2IResources.deploymentName((String)kafkaConnectS2I.getMetadata().getName()));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().contains("-connect-")).forEach(p -> {
            LOGGER.debug("Deleting: {}", (Object)p.getMetadata().getName());
            ResourceManager.kubeClient().deletePod(p);
        });
    }

    private static void waitForDeletion(KafkaMirrorMaker kafkaMirrorMaker) {
        LOGGER.info("Waiting when all the Pods are terminated for KafkaMirrorMaker {}", (Object)kafkaMirrorMaker.getMetadata().getName());
        DeploymentUtils.waitForDeploymentDeletion(KafkaMirrorMakerResources.deploymentName((String)kafkaMirrorMaker.getMetadata().getName()));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaMirrorMakerResources.deploymentName((String)kafkaMirrorMaker.getMetadata().getName()));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(KafkaMirrorMaker2Resources.deploymentName((String)kafkaMirrorMaker.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    private static void waitForDeletion(KafkaMirrorMaker2 kafkaMirrorMaker2) {
        LOGGER.info("Waiting when all the Pods are terminated for KafkaMirrorMaker2 {}", (Object)kafkaMirrorMaker2.getMetadata().getName());
        DeploymentUtils.waitForDeploymentDeletion(KafkaMirrorMaker2Resources.deploymentName((String)kafkaMirrorMaker2.getMetadata().getName()));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaMirrorMaker2Resources.deploymentName((String)kafkaMirrorMaker2.getMetadata().getName()));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(KafkaMirrorMaker2Resources.deploymentName((String)kafkaMirrorMaker2.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    private static void waitForDeletion(KafkaBridge kafkaBridge) {
        LOGGER.info("Waiting when all the Pods are terminated for KafkaBridge {}", (Object)kafkaBridge.getMetadata().getName());
        DeploymentUtils.waitForDeploymentDeletion(KafkaBridgeResources.deploymentName((String)kafkaBridge.getMetadata().getName()));
        ReplicaSetUtils.waitForReplicaSetDeletion(KafkaBridgeResources.deploymentName((String)kafkaBridge.getMetadata().getName()));
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(KafkaBridgeResources.deploymentName((String)kafkaBridge.getMetadata().getName()))).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    private static void waitForDeletion(Deployment deployment) {
        LOGGER.info("Waiting when all the pods are terminated for Deployment {}", (Object)deployment.getMetadata().getName());
        DeploymentUtils.waitForDeploymentDeletion(deployment.getMetadata().getName());
        ResourceManager.kubeClient().listPods().stream().filter(p -> p.getMetadata().getName().startsWith(deployment.getMetadata().getName())).forEach(p -> PodUtils.deletePodWithWait(p.getMetadata().getName()));
    }

    public static void deleteClassResources() {
        LOGGER.info("-----CLEARING CLASS RESOURCES-----");
        while (!classResources.empty()) {
            classResources.pop().run();
        }
        classResources.clear();
        LOGGER.info("-----CLASS RESOURCES CLEARED-----");
    }

    public static void deleteMethodResources() {
        LOGGER.info("-----CLEARING METHOD RESOURCES-----");
        while (!methodResources.empty()) {
            methodResources.pop().run();
        }
        methodResources.clear();
        pointerResources = classResources;
        LOGGER.info("-----METHOD RESOURCES CLEARED-----");
    }

    public static <T extends CustomResource<? extends Spec, ? extends Status>> void logCurrentResourceStatus(T customResource) {
        if (customResource != null) {
            List<String> printWholeCR = Arrays.asList("KafkaConnector", "KafkaTopic", "KafkaUser");
            String kind = customResource.getKind();
            String name = customResource.getMetadata().getName();
            if (printWholeCR.contains(kind)) {
                LOGGER.info(customResource);
            } else {
                ArrayList<String> log = new ArrayList<String>(Arrays.asList("\n", kind, " status:\n", "\nConditions:\n"));
                if (customResource.getStatus() != null) {
                    List conditions = ((Status)customResource.getStatus()).getConditions();
                    if (conditions != null) {
                        for (Condition condition : ((Status)customResource.getStatus()).getConditions()) {
                            if (condition.getMessage() == null) continue;
                            log.add("\tType: " + condition.getType() + "\n");
                            log.add("\tMessage: " + condition.getMessage() + "\n");
                        }
                    }
                    log.add("\nPods with conditions and messages:\n\n");
                    for (Pod pod : ResourceManager.kubeClient().listPodsByPrefixInName(name)) {
                        log.add(pod.getMetadata().getName() + ":");
                        for (PodCondition podCondition : pod.getStatus().getConditions()) {
                            if (podCondition.getMessage() == null) continue;
                            log.add("\n\tType: " + podCondition.getType() + "\n");
                            log.add("\tMessage: " + podCondition.getMessage() + "\n");
                        }
                        log.add("\n\n");
                    }
                    LOGGER.info("{}", (Object)String.join((CharSequence)"", log));
                }
            }
        }
    }

    public static <T extends CustomResource<? extends Spec, ? extends Status>> T waitForResourceStatus(MixedOperation<T, ?, ?> operation, T resource, Enum<?> status, long resourceTimeout) {
        ResourceManager.waitForResourceStatus(operation, resource.getKind(), resource.getMetadata().getNamespace(), resource.getMetadata().getName(), status, resourceTimeout);
        return resource;
    }

    public static <T extends CustomResource<? extends Spec, ? extends Status>> void waitForResourceStatus(MixedOperation<T, ?, ?> operation, String kind, String namespace, String name, Enum<?> status, long resourceTimeoutMs) {
        LOGGER.info("Wait for {}: {} will have desired state: {}", (Object)kind, (Object)name, status);
        TestUtils.waitFor((String)String.format("Wait for %s: %s will have desired state: %s", kind, name, status), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)resourceTimeoutMs, () -> ((Status)((CustomResource)((Resource)((NonNamespaceOperation)operation.inNamespace(namespace)).withName(name)).get()).getStatus()).getConditions().stream().anyMatch(condition -> condition.getType().equals(status.toString())), () -> ResourceManager.logCurrentResourceStatus((CustomResource)((Resource)((NonNamespaceOperation)operation.inNamespace(namespace)).withName(name)).get()));
        LOGGER.info("{}: {} is in desired state: {}", (Object)kind, (Object)name, status);
    }

    public static <T extends CustomResource<? extends Spec, ? extends Status>> T waitForResourceStatus(MixedOperation<T, ?, ?> operation, T resource, Enum<?> status) {
        long resourceTimeout = ResourceOperation.getTimeoutForResourceReadiness(resource.getKind());
        return ResourceManager.waitForResourceStatus(operation, resource, status, resourceTimeout);
    }

    private static Deployment getDeploymentFromYaml(String yamlPath) {
        return (Deployment)TestUtils.configFromYaml((String)yamlPath, Deployment.class);
    }

    public static String getCoDeploymentName() {
        return coDeploymentName;
    }

    public static void setCoDeploymentName(String newName) {
        coDeploymentName = newName;
    }
}

