/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources;

import io.strimzi.api.kafka.model.balancing.KafkaRebalanceState;
import java.time.Duration;

public class ResourceOperation {
    public static long getTimeoutForResourceReadiness() {
        return ResourceOperation.getTimeoutForResourceReadiness("default");
    }

    public static long getTimeoutForResourceReadiness(String kind) {
        long timeout;
        switch (kind) {
            case "Kafka": {
                timeout = Duration.ofMinutes(14L).toMillis();
                break;
            }
            case "KafkaConnect": 
            case "KafkaConnectS2I": 
            case "KafkaMirrorMaker2": 
            case "DeploymentConfig": {
                timeout = Duration.ofMinutes(10L).toMillis();
                break;
            }
            case "KafkaMirrorMaker": 
            case "KafkaBridge": 
            case "StatefulSet": 
            case "KafkaWithCruiseControl": 
            case "KafkaWithExporter": 
            case "Deployment": {
                timeout = Duration.ofMinutes(8L).toMillis();
                break;
            }
            case "KafkaConnector": {
                timeout = Duration.ofMinutes(4L).toMillis();
                break;
            }
            default: {
                timeout = Duration.ofMinutes(3L).toMillis();
            }
        }
        return timeout;
    }

    public static long getTimeoutForKafkaRebalanceState(KafkaRebalanceState state) {
        long timeout;
        switch (state) {
            case ProposalReady: 
            case Ready: 
            case Rebalancing: {
                timeout = Duration.ofMinutes(10L).toMillis();
                break;
            }
            default: {
                timeout = Duration.ofMinutes(6L).toMillis();
            }
        }
        return timeout;
    }

    public static long timeoutForPodsOperation(int numberOfPods) {
        return Duration.ofMinutes(5L).toMillis() * (long)Math.max(1, numberOfPods);
    }

    public static long getTimeoutForResourceDeletion() {
        return ResourceOperation.getTimeoutForResourceDeletion("default");
    }

    public static long getTimeoutForResourceDeletion(String kind) {
        long timeout;
        switch (kind) {
            case "Kafka": 
            case "KafkaConnect": 
            case "KafkaConnectS2I": 
            case "KafkaMirrorMaker2": 
            case "KafkaMirrorMaker": 
            case "KafkaBridge": 
            case "StatefulSet": 
            case "Pod": {
                timeout = Duration.ofMinutes(5L).toMillis();
                break;
            }
            default: {
                timeout = Duration.ofMinutes(3L).toMillis();
            }
        }
        return timeout;
    }
}

