/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.KafkaConnectResources;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.KafkaResources;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.KubernetesResource;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.function.Consumer;

public class KafkaConnectResource {
    public static final String PATH_TO_KAFKA_CONNECT_CONFIG = TestUtils.USER_PATH + "/../examples/connect/kafka-connect.yaml";

    public static MixedOperation<KafkaConnect, KafkaConnectList, Resource<KafkaConnect>> kafkaConnectClient() {
        return Crds.kafkaConnectOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaConnectBuilder kafkaConnect(String name, int kafkaConnectReplicas) {
        return KafkaConnectResource.kafkaConnect(name, name, kafkaConnectReplicas);
    }

    public static KafkaConnectBuilder kafkaConnect(String name, String clusterName, int kafkaConnectReplicas) {
        KafkaConnect kafkaConnect = KafkaConnectResource.getKafkaConnectFromYaml(PATH_TO_KAFKA_CONNECT_CONFIG);
        return KafkaConnectResource.defaultKafkaConnect(kafkaConnect, name, clusterName, kafkaConnectReplicas);
    }

    public static KafkaConnectBuilder kafkaConnectWithMetrics(String name, int kafkaConnectReplicas) {
        return KafkaConnectResource.kafkaConnectWithMetrics(name, name, kafkaConnectReplicas);
    }

    public static KafkaConnectBuilder kafkaConnectWithMetrics(String name, String clusterName, int kafkaConnectReplicas) {
        KafkaConnect kafkaConnect = KafkaConnectResource.getKafkaConnectFromYaml(Constants.PATH_TO_KAFKA_CONNECT_METRICS_CONFIG);
        ConfigMap metricsCm = TestUtils.configMapFromYaml((String)Constants.PATH_TO_KAFKA_CONNECT_METRICS_CONFIG, (String)"connect-metrics");
        ((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().configMaps().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new ConfigMap[]{metricsCm});
        return KafkaConnectResource.defaultKafkaConnect(kafkaConnect, name, clusterName, kafkaConnectReplicas);
    }

    private static KafkaConnectBuilder defaultKafkaConnect(KafkaConnect kafkaConnect, String name, String kafkaClusterName, int kafkaConnectReplicas) {
        return (KafkaConnectBuilder)((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.InlineLoggingNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectSpecFluent.TlsNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectBuilder)((KafkaConnectFluent.MetadataNested)((KafkaConnectFluent.MetadataNested)((KafkaConnectFluent.MetadataNested)new KafkaConnectBuilder(kafkaConnect).withNewMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).withClusterName(kafkaClusterName)).endMetadata()).editOrNewSpec().withVersion(Environment.ST_KAFKA_VERSION)).withBootstrapServers(KafkaResources.tlsBootstrapAddress((String)kafkaClusterName))).withReplicas(Integer.valueOf(kafkaConnectReplicas))).withNewTls().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withNewSecretName(kafkaClusterName + "-cluster-ca-cert")).withCertificate("ca.crt")).build()})).endTls()).addToConfig("group.id", (Object)KafkaConnectResources.deploymentName((String)kafkaClusterName))).addToConfig("offset.storage.topic", (Object)KafkaConnectResources.configStorageTopicOffsets((String)kafkaClusterName))).addToConfig("config.storage.topic", (Object)KafkaConnectResources.metricsAndLogConfigMapName((String)kafkaClusterName))).addToConfig("status.storage.topic", (Object)KafkaConnectResources.configStorageTopicStatus((String)kafkaClusterName))).withNewInlineLogging().addToLoggers("connect.root.logger.level", "DEBUG")).endInlineLogging()).endSpec();
    }

    public static KafkaConnect createAndWaitForReadiness(KafkaConnect kafkaConnect) {
        return KafkaConnectResource.createAndWaitForReadiness(kafkaConnect, true);
    }

    public static KafkaConnect createAndWaitForReadiness(KafkaConnect kafkaConnect, boolean allowNP) {
        if (allowNP) {
            KubernetesResource.deployNetworkPolicyForResource(kafkaConnect, KafkaConnectResources.deploymentName((String)kafkaConnect.getMetadata().getName()));
        }
        TestUtils.waitFor((String)"KafkaConnect creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaConnectResource.waitFor(KafkaConnectResource.deleteLater(kafkaConnect));
    }

    public static KafkaConnect kafkaConnectWithoutWait(KafkaConnect kafkaConnect) {
        ((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
        return kafkaConnect;
    }

    public static void deleteKafkaConnectWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaConnectResource.kafkaConnectClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaConnect getKafkaConnectFromYaml(String yamlPath) {
        return (KafkaConnect)TestUtils.configFromYaml((String)yamlPath, KafkaConnect.class);
    }

    private static KafkaConnect waitFor(KafkaConnect kafkaConnect) {
        return ResourceManager.waitForResourceStatus(KafkaConnectResource.kafkaConnectClient(), kafkaConnect, CustomResourceStatus.Ready);
    }

    private static KafkaConnect deleteLater(KafkaConnect kafkaConnect) {
        return ResourceManager.deleteLater(KafkaConnectResource.kafkaConnectClient(), kafkaConnect);
    }

    public static void replaceKafkaConnectResource(String resourceName, Consumer<KafkaConnect> editor) {
        ResourceManager.replaceCrdResource(KafkaConnect.class, KafkaConnectList.class, resourceName, editor);
    }
}

