/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.crd;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaRebalanceList;
import io.strimzi.api.kafka.model.KafkaRebalance;
import io.strimzi.api.kafka.model.KafkaRebalanceBuilder;
import io.strimzi.api.kafka.model.KafkaRebalanceFluent;
import io.strimzi.api.kafka.model.balancing.KafkaRebalanceState;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.test.TestUtils;
import java.util.HashMap;
import java.util.function.Consumer;

public class KafkaRebalanceResource {
    public static final String PATH_TO_KAFKA_REBALANCE_CONFIG = TestUtils.USER_PATH + "/../examples/cruise-control/kafka-rebalance.yaml";

    public static MixedOperation<KafkaRebalance, KafkaRebalanceList, Resource<KafkaRebalance>> kafkaRebalanceClient() {
        return Crds.kafkaRebalanceOperation((KubernetesClient)ResourceManager.kubeClient().getClient());
    }

    public static KafkaRebalanceBuilder kafkaRebalance(String name) {
        KafkaRebalance kafkaRebalance = KafkaRebalanceResource.getKafkaRebalanceFromYaml(PATH_TO_KAFKA_REBALANCE_CONFIG);
        return KafkaRebalanceResource.defaultKafkaRebalance(kafkaRebalance, name);
    }

    private static KafkaRebalanceBuilder defaultKafkaRebalance(KafkaRebalance kafkaRebalance, String name) {
        HashMap<String, String> kafkaRebalanceLabels = new HashMap<String, String>();
        kafkaRebalanceLabels.put("strimzi.io/cluster", name);
        return (KafkaRebalanceBuilder)((KafkaRebalanceFluent.MetadataNested)((KafkaRebalanceFluent.MetadataNested)((KafkaRebalanceFluent.MetadataNested)new KafkaRebalanceBuilder(kafkaRebalance).editMetadata().withName(name)).withNamespace(ResourceManager.kubeClient().getNamespace())).withLabels(kafkaRebalanceLabels)).endMetadata();
    }

    public static KafkaRebalance createAndWaitForReadiness(KafkaRebalance kafkaRebalance) {
        TestUtils.waitFor((String)"KafkaRebalance creation", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_CREATION, (long)ResourceManager.CR_CREATION_TIMEOUT, () -> {
            try {
                ((NonNamespaceOperation)KafkaRebalanceResource.kafkaRebalanceClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaRebalance[]{kafkaRebalance});
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getMessage().contains("object is being deleted")) {
                    return false;
                }
                throw e;
            }
        });
        return KafkaRebalanceResource.waitFor(KafkaRebalanceResource.deleteLater(kafkaRebalance));
    }

    public static KafkaRebalance kafkaRebalanceWithoutWait(KafkaRebalance kafkaRebalance) {
        ((NonNamespaceOperation)KafkaRebalanceResource.kafkaRebalanceClient().inNamespace(ResourceManager.kubeClient().getNamespace())).createOrReplace((Object[])new KafkaRebalance[]{kafkaRebalance});
        return kafkaRebalance;
    }

    public static void deleteKafkaRebalanceWithoutWait(String resourceName) {
        ((EditReplacePatchDeletable)((Resource)((NonNamespaceOperation)KafkaRebalanceResource.kafkaRebalanceClient().inNamespace(ResourceManager.kubeClient().getNamespace())).withName(resourceName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).delete();
    }

    private static KafkaRebalance getKafkaRebalanceFromYaml(String yamlPath) {
        return (KafkaRebalance)TestUtils.configFromYaml((String)yamlPath, KafkaRebalance.class);
    }

    private static KafkaRebalance waitFor(KafkaRebalance kafkaRebalance) {
        long timeout = ResourceOperation.getTimeoutForKafkaRebalanceState(KafkaRebalanceState.PendingProposal);
        return ResourceManager.waitForResourceStatus(KafkaRebalanceResource.kafkaRebalanceClient(), kafkaRebalance, KafkaRebalanceState.PendingProposal, timeout);
    }

    private static KafkaRebalance deleteLater(KafkaRebalance kafkaRebalance) {
        return ResourceManager.deleteLater(KafkaRebalanceResource.kafkaRebalanceClient(), kafkaRebalance);
    }

    public static void replaceKafkaRebalanceResource(String resourceName, Consumer<KafkaRebalance> editor) {
        ResourceManager.replaceCrdResource(KafkaRebalance.class, KafkaRebalanceList.class, resourceName, editor);
    }
}

