/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.resources.operator;

import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.Environment;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.utils.kubeUtils.controllers.DeploymentUtils;
import io.strimzi.systemtest.utils.specific.BridgeUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelmResource {
    private static final Logger LOGGER = LogManager.getLogger(HelmResource.class);
    public static final String HELM_CHART = TestUtils.USER_PATH + "/../helm-charts/helm3/strimzi-kafka-operator/";
    public static final String HELM_RELEASE_NAME = "strimzi-systemtests";
    public static final String REQUESTS_MEMORY = "512Mi";
    public static final String REQUESTS_CPU = "200m";
    public static final String LIMITS_MEMORY = "512Mi";
    public static final String LIMITS_CPU = "1000m";

    public static void clusterOperator() {
        HelmResource.clusterOperator(Constants.CO_OPERATION_TIMEOUT_DEFAULT);
    }

    public static void clusterOperator(long operationTimeout) {
        HelmResource.clusterOperator(operationTimeout, Constants.RECONCILIATION_INTERVAL);
    }

    public static void clusterOperator(long operationTimeout, long reconciliationInterval) {
        Map values = Collections.unmodifiableMap((Map)Stream.of(TestUtils.entry((Object)"image.registry", (Object)Environment.STRIMZI_REGISTRY), TestUtils.entry((Object)"topicOperator.image.registry", (Object)Environment.STRIMZI_REGISTRY), TestUtils.entry((Object)"userOperator.image.registry", (Object)Environment.STRIMZI_REGISTRY), TestUtils.entry((Object)"kafkaInit.image.registry", (Object)Environment.STRIMZI_REGISTRY), TestUtils.entry((Object)"jmxTrans.image.registry", (Object)Environment.STRIMZI_REGISTRY), TestUtils.entry((Object)"kafkaBridge.image.registry", (Object)"quay.io"), TestUtils.entry((Object)"image.repository", (Object)Environment.STRIMZI_ORG), TestUtils.entry((Object)"topicOperator.image.repository", (Object)Environment.STRIMZI_ORG), TestUtils.entry((Object)"userOperator.image.repository", (Object)Environment.STRIMZI_ORG), TestUtils.entry((Object)"kafkaInit.image.repository", (Object)Environment.STRIMZI_ORG), TestUtils.entry((Object)"jmxTrans.image.repository", (Object)Environment.STRIMZI_ORG), TestUtils.entry((Object)"kafkaBridge.image.repository", (Object)"strimzi"), TestUtils.entry((Object)"image.tag", (Object)Environment.STRIMZI_TAG), TestUtils.entry((Object)"topicOperator.image.tag", (Object)Environment.STRIMZI_TAG), TestUtils.entry((Object)"userOperator.image.tag", (Object)Environment.STRIMZI_TAG), TestUtils.entry((Object)"kafkaInit.image.tag", (Object)Environment.STRIMZI_TAG), TestUtils.entry((Object)"jmxTrans.image.tag", (Object)Environment.STRIMZI_TAG), TestUtils.entry((Object)"kafkaBridge.image.tag", (Object)(Environment.useLatestReleasedBridge() ? "latest" : BridgeUtils.getBridgeVersion())), TestUtils.entry((Object)"image.imagePullPolicy", (Object)Environment.OPERATOR_IMAGE_PULL_POLICY), TestUtils.entry((Object)"resources.requests.memory", (Object)"512Mi"), TestUtils.entry((Object)"resources.requests.cpu", (Object)REQUESTS_CPU), TestUtils.entry((Object)"resources.limits.memory", (Object)"512Mi"), TestUtils.entry((Object)"resources.limits.cpu", (Object)LIMITS_CPU), TestUtils.entry((Object)"logLevelOverride", (Object)Environment.STRIMZI_LOG_LEVEL), TestUtils.entry((Object)"fullReconciliationIntervalMs", (Object)Long.toString(reconciliationInterval)), TestUtils.entry((Object)"operationTimeoutMs", (Object)Long.toString(operationTimeout))).collect(TestUtils.entriesToMap()));
        Path pathToChart = new File(HELM_CHART).toPath();
        String oldNamespace = KubeClusterResource.getInstance().setNamespace("kube-system");
        InputStream helmAccountAsStream = HelmResource.class.getClassLoader().getResourceAsStream("helm/helm-service-account.yaml");
        String helmServiceAccount = TestUtils.readResource((InputStream)helmAccountAsStream);
        KubeClusterResource.cmdKubeClient().applyContent(helmServiceAccount);
        KubeClusterResource.getInstance().setNamespace(oldNamespace);
        ResourceManager.getPointerResources().push(HelmResource::deleteClusterOperator);
        ResourceManager.helmClient().install(pathToChart, HELM_RELEASE_NAME, values);
        DeploymentUtils.waitForDeploymentReady(ResourceManager.getCoDeploymentName());
    }

    public static void deleteClusterOperator() {
        ResourceManager.helmClient().delete(HELM_RELEASE_NAME);
        DeploymentUtils.waitForDeploymentDeletion(ResourceManager.getCoDeploymentName());
        KubeClusterResource.cmdKubeClient().delete(new String[]{TestUtils.USER_PATH + "/../install/cluster-operator"});
    }
}

