/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.resources.crd.KafkaUserResource;
import io.strimzi.systemtest.utils.kubeUtils.objects.SecretUtils;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaUserUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaUserUtils.class);
    private static final String KAFKA_USER_NAME_PREFIX = "my-user-";
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private KafkaUserUtils() {
    }

    public static String generateRandomNameOfKafkaUser() {
        String salt = new Random().nextInt(Integer.MAX_VALUE) + "-" + new Random().nextInt(Integer.MAX_VALUE);
        return KAFKA_USER_NAME_PREFIX + salt;
    }

    public static void waitForKafkaUserCreation(String userName) {
        KafkaUser kafkaUser = (KafkaUser)((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get();
        SecretUtils.waitForSecretReady(userName, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get()));
        ResourceManager.waitForResourceStatus(KafkaUserResource.kafkaUserClient(), kafkaUser, CustomResourceStatus.Ready);
    }

    public static void waitForKafkaUserDeletion(String userName) {
        LOGGER.info("Waiting for KafkaUser deletion {}", (Object)userName);
        TestUtils.waitFor((String)("KafkaUser deletion " + userName), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> {
            if (((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get() == null) {
                return true;
            }
            LOGGER.warn("KafkaUser {} is not deleted yet! Triggering force delete by cmd client!", (Object)userName);
            KubeClusterResource.cmdKubeClient().deleteByName("KafkaUser", userName);
            return false;
        }, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get()));
        LOGGER.info("KafkaUser {} deleted", (Object)userName);
    }

    public static void waitForKafkaUserIncreaseObserverGeneration(long observation, String userName) {
        TestUtils.waitFor((String)("increase observation generation from " + observation + " for user " + userName), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_STATUS_TIMEOUT, () -> observation < ((KafkaUser)((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get()).getStatus().getObservedGeneration());
    }

    public static void waitUntilKafkaUserStatusConditionIsPresent(String userName) {
        LOGGER.info("Wait until KafkaUser {} status is available", (Object)userName);
        TestUtils.waitFor((String)("KafkaUser " + userName + " status is available"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> ((KafkaUser)((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get()).getStatus().getConditions() != null, () -> LOGGER.info(((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get()));
        LOGGER.info("KafkaUser {} status is available", (Object)userName);
    }

    public static void waitForKafkaUserStatus(String userName, Enum<?> state) {
        KafkaUser kafkaUser = (KafkaUser)((Resource)((NonNamespaceOperation)KafkaUserResource.kafkaUserClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(userName)).get();
        ResourceManager.waitForResourceStatus(KafkaUserResource.kafkaUserClient(), kafkaUser, state);
    }

    public static void waitForKafkaUserReady(String userName) {
        KafkaUserUtils.waitForKafkaUserStatus(userName, CustomResourceStatus.Ready);
    }

    public static void waitForKafkaUserNotReady(String userName) {
        KafkaUserUtils.waitForKafkaUserStatus(userName, CustomResourceStatus.NotReady);
    }
}

