/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kubeUtils.objects;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.security.CertAndKeyFiles;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecretUtils {
    private static final Logger LOGGER = LogManager.getLogger(SecretUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("Secret");
    private static final long DELETION_TIMEOUT = ResourceOperation.getTimeoutForResourceDeletion();

    private SecretUtils() {
    }

    public static void waitForSecretReady(String secretName) {
        SecretUtils.waitForSecretReady(secretName, () -> {});
    }

    public static void waitForSecretReady(String secretName, Runnable onTimeout) {
        LOGGER.info("Waiting for Secret {}", (Object)secretName);
        TestUtils.waitFor((String)("Expected secret " + secretName + " exists"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> KubeClusterResource.kubeClient().getSecret(secretName) != null, (Runnable)onTimeout);
        LOGGER.info("Secret {} created", (Object)secretName);
    }

    public static void waitForSecretDeletion(String secretName) {
        SecretUtils.waitForSecretDeletion(secretName, () -> {});
    }

    public static void waitForSecretDeletion(String secretName, Runnable onTimeout) {
        LOGGER.info("Waiting for Secret deletion {}", (Object)secretName);
        TestUtils.waitFor((String)("Expected secret " + secretName + " deleted"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)READINESS_TIMEOUT, () -> KubeClusterResource.kubeClient().getSecret(secretName) == null, (Runnable)onTimeout);
        LOGGER.info("Secret {} deleted", (Object)secretName);
    }

    public static void createSecret(String secretName, String dataKey, String dataValue) {
        LOGGER.info("Creating secret {}", (Object)secretName);
        KubeClusterResource.kubeClient().createSecret(((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretBuilder)((SecretBuilder)new SecretBuilder().withNewApiVersion("v1")).withNewKind("Secret")).withNewMetadata().withName(secretName)).endMetadata()).withNewType("Opaque")).withData(Collections.singletonMap(dataKey, dataValue))).build());
    }

    public static void createSecretFromFile(String pathToOrigin, String key, String name, String namespace) {
        SecretUtils.createSecretFromFile(Collections.singletonMap(key, pathToOrigin), name, namespace, null);
    }

    public static void createSecretFromFile(String pathToOrigin, String key, String name, String namespace, Map<String, String> labels) {
        SecretUtils.createSecretFromFile(Collections.singletonMap(key, pathToOrigin), name, namespace, labels);
    }

    public static void createSecretFromFile(Map<String, String> certFilesPath, String name, String namespace) {
        SecretUtils.createSecretFromFile(certFilesPath, name, namespace, null);
    }

    public static void createSecretFromFile(Map<String, String> certFilesPath, String name, String namespace, Map<String, String> labels) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : certFilesPath.entrySet()) {
                byte[] encoded = Files.readAllBytes(Paths.get(entry.getValue(), new String[0]));
                Base64.Encoder encoder = Base64.getEncoder();
                data.put(entry.getKey(), encoder.encodeToString(encoded));
            }
            Secret secret = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withData(data)).withNewMetadata().withName(name)).withNamespace(namespace)).addToLabels(labels)).endMetadata()).build();
            KubeClusterResource.kubeClient().namespace(namespace).createSecret(secret);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void waitForClusterSecretsDeletion(String clusterName) {
        LOGGER.info("Waiting for Secret {} deletion", (Object)clusterName);
        TestUtils.waitFor((String)("Secret " + clusterName + " deletion"), (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)DELETION_TIMEOUT, () -> {
            List secretList = KubeClusterResource.kubeClient().listSecrets("strimzi.io/cluster", clusterName);
            if (secretList.isEmpty()) {
                return true;
            }
            for (Secret secret : secretList) {
                LOGGER.warn("Secret {} is not deleted yet! Triggering force delete by cmd client!", (Object)secret.getMetadata().getName());
                KubeClusterResource.cmdKubeClient().deleteByName("secret", secret.getMetadata().getName());
            }
            return false;
        });
        LOGGER.info("Secret {} deleted", (Object)clusterName);
    }

    public static void createCustomSecret(String name, String clusterName, String namespace, CertAndKeyFiles certAndKeyFiles) {
        HashMap<String, String> secretLabels = new HashMap<String, String>();
        secretLabels.put("strimzi.io/cluster", clusterName);
        secretLabels.put("strimzi.io/kind", "Kafka");
        HashMap<String, String> certsPaths = new HashMap<String, String>();
        certsPaths.put("ca.crt", certAndKeyFiles.getCertPath());
        certsPaths.put("ca.key", certAndKeyFiles.getKeyPath());
        SecretUtils.createSecretFromFile(certsPaths, name, namespace, secretLabels);
        SecretUtils.waitForSecretReady(name);
    }

    public static void waitForCertToChange(String originalCert, String secretName) {
        LOGGER.info("Waiting for Secret {} certificate change", (Object)secretName);
        TestUtils.waitFor((String)"Cert to be replaced", (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.TIMEOUT_FOR_CLUSTER_STABLE, () -> {
            Secret secret = KubeClusterResource.kubeClient().getSecret(secretName);
            if (secret != null && secret.getData() != null && secret.getData().containsKey("ca.crt")) {
                boolean changed;
                String currentCert = new String(Base64.getDecoder().decode((String)secret.getData().get("ca.crt")), StandardCharsets.US_ASCII);
                boolean bl = changed = !originalCert.equals(currentCert);
                if (changed) {
                    LOGGER.info("Certificate in Secret {} has changed, was {}, is now {}", (Object)secretName, (Object)originalCert, (Object)currentCert);
                }
                return changed;
            }
            return false;
        });
    }

    public static void deleteSecretWithWait(String secretName, String namespace) {
        ((Resource)((NonNamespaceOperation)KubeClusterResource.kubeClient().getClient().secrets().inNamespace(namespace)).withName(secretName)).delete();
        LOGGER.info("Waiting for Secret: {} to be deleted", (Object)secretName);
        TestUtils.waitFor((String)String.format("Deletion of secret: %s", secretName), (long)Constants.GLOBAL_POLL_INTERVAL, (long)DELETION_TIMEOUT, () -> KubeClusterResource.kubeClient().getSecret(secretName) == null);
        LOGGER.info("Secret: {} successfully deleted", (Object)secretName);
    }

    public static X509Certificate getCertificateFromSecret(Secret secret, String dataKey) {
        String caCert = (String)secret.getData().get(dataKey);
        byte[] decoded = Base64.getDecoder().decode(caCert);
        X509Certificate cacert = null;
        try {
            cacert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return cacert;
    }
}

