/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.verifyica.pipeliner.common.Timestamp;

public class Console {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.ENGLISH);
    private boolean trace;
    private boolean logging;
    private boolean timestamps;
    private boolean minimal;
    private PrintStream filePrintStream;

    public void initialize() throws IOException {
        if (this.logging) {
            String filename;
            File file;
            do {
                filename = "pipeline_" + this.simpleDateFormat.format(new Date()) + ".log";
                file = new File(filename);
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (file.exists());
            FileOutputStream fileOutputStream = new FileOutputStream(filename, false);
            this.filePrintStream = new PrintStream((OutputStream)fileOutputStream, true, StandardCharsets.UTF_8.name());
            this.trace("log filename [%s]", filename);
        }
    }

    public void enableTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
    }

    public void enableTrace(boolean trace) {
        this.trace = trace;
    }

    public void enableLogging(boolean logging) {
        this.logging = logging;
    }

    public void enableMinimal(boolean minimal) {
        this.minimal = minimal;
    }

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public void log(String format, Object ... objects) {
        this.log(String.format(format, objects));
    }

    public void log(Object object) {
        String timestamp = Timestamp.now();
        String prefix = this.timestamps ? timestamp + " " : "";
        String message = prefix + object;
        if (this.minimal && !message.startsWith("$") && !message.startsWith(">") && !message.startsWith("@error")) {
            return;
        }
        System.out.println(message);
        System.out.flush();
        if (this.logging) {
            this.filePrintStream.println(message);
            this.filePrintStream.flush();
        }
    }

    public void error(Object object) {
        this.log(String.format("@error %s", object));
    }

    public void error(String format, Object ... objects) {
        this.log("@error " + format, objects);
    }

    public void trace(String format, Object ... objects) {
        if (this.trace) {
            this.log("@trace " + format, objects);
        }
    }

    public void close() {
        System.out.flush();
        if (this.filePrintStream != null) {
            try {
                this.filePrintStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void closeAndExit(int exitCode) {
        this.close();
        System.exit(exitCode);
    }
}

