/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.Stopwatch;
import org.verifyica.pipeliner.core.Executable;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.Step;

public class Job
implements Executable {
    private final Pipeline pipeline;
    private final String reference;
    private String id;
    private String name;
    private boolean enabled;
    private final Map<String, String> environmentVariables;
    private final Map<String, String> properties;
    private final Map<String, String> options;
    private final List<Step> steps;
    private int exitCode;
    private final Stopwatch stopwatch;

    public Job(Pipeline pipeline, int index) {
        this.pipeline = pipeline;
        this.reference = pipeline.getReference() + "-job-" + index;
        this.enabled = true;
        this.environmentVariables = new LinkedHashMap<String, String>();
        this.properties = new LinkedHashMap<String, String>();
        this.options = new LinkedHashMap<String, String>();
        this.steps = new ArrayList<Step>();
        this.stopwatch = new Stopwatch();
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public String getReference() {
        return this.reference;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        if (id != null) {
            this.id = id.trim();
        }
    }

    public String getId() {
        return this.id != null ? this.id : this.reference;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    private void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void execute(Executable.Mode mode, Console console) {
        if (mode == Executable.Mode.ENABLED) {
            this.stopwatch.reset();
            console.log(this);
            if (this.isEnabled()) {
                Iterator<Step> iterator = this.getSteps().iterator();
                while (iterator.hasNext()) {
                    Step step2 = iterator.next();
                    if (step2.isEnabled()) {
                        step2.execute(Executable.Mode.ENABLED, console);
                        if (step2.getExitCode() == 0) continue;
                        step2.getJob().setExitCode(step2.getExitCode());
                        break;
                    }
                    step2.execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
                }
                while (iterator.hasNext()) {
                    iterator.next().execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
                }
            } else {
                for (Step step3 : this.getSteps()) {
                    step3.execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
                }
            }
            this.getSteps().stream().filter(step -> step.getExitCode() != 0).findFirst().ifPresent(step -> this.setExitCode(step.getExitCode()));
            if (this.isEnabled()) {
                console.log("%s exit-code=[%d] ms=[%d]", this, this.getExitCode(), this.stopwatch.elapsedTime().toMillis());
            }
        } else {
            console.log(this);
            for (Step step4 : this.getSteps()) {
                step4.execute(Executable.Mode.SKIPPED_OR_DISABLED, console);
            }
        }
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        return String.format("@job name=[%s] id=[%s] ref=[%s]", this.getName() == null ? "" : this.getName(), this.getId(), this.getReference());
    }
}

