/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.RecursiveReplacer;
import org.verifyica.pipeliner.common.Validator;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.common.Version;
import org.verifyica.pipeliner.common.io.NoOpPrintStream;
import org.verifyica.pipeliner.common.io.StringPrintStream;
import org.verifyica.pipeliner.core.CaptureType;
import org.verifyica.pipeliner.core.Executable;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.ShellType;
import org.verifyica.pipeliner.core.Step;

public class Run
implements Executable {
    private static final String PROPERTY_MATCHING_REGEX = "(?<!\\\\)\\$\\{\\{\\s*([a-zA-Z0-9_\\-.]+)\\s*\\}\\}";
    private static final String ENVIRONMENT_VARIABLE_MATCHING_REGEX = "(?<!\\\\)\\$(\\w+)";
    private Console console;
    private final Validator validator;
    private final Step step;
    private final String command;
    private CaptureType captureType;
    private String captureVariable;
    private int exitCode;

    public Run(Step step, String command) {
        this.step = step;
        this.command = command;
        this.captureType = CaptureType.NONE;
        this.captureVariable = null;
        this.validator = new Validator();
    }

    public Step getStep() {
        return this.step;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCapture(CaptureType captureType, String captureVariable) {
        this.captureType = captureType;
        this.captureVariable = captureVariable;
    }

    private void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void execute(Executable.Mode mode, Console console) {
        if (mode == Executable.Mode.ENABLED) {
            String propertyKey;
            String property;
            this.console = console;
            Step step = this.getStep();
            Job job = step.getJob();
            Pipeline pipeline = job.getPipeline();
            Map<String, String> environmentVariables = Run.merge(System.getenv(), pipeline.getEnvironmentVariables(), job.getEnvironmentVariables(), step.getEnvironmentVariables());
            Map<String, String> properties = Run.merge(pipeline.getProperties(), job.getProperties(), step.getProperties());
            Map<String, String> options = Run.merge(pipeline.getOptions(), job.getOptions(), step.getOptions());
            String version = Version.getVersion();
            environmentVariables.put("PIPELINER_VERSION", version);
            properties.put("INPUT_PIPELINER_VERSION", version);
            if (console.isTraceEnabled()) {
                environmentVariables.forEach((name, value) -> console.trace("environment variable [%s] = [%s]", name, value));
            }
            if (console.isTraceEnabled()) {
                properties.forEach((name, value) -> console.trace("property [%s] = [%s]", name, value));
            }
            if (console.isTraceEnabled()) {
                options.forEach((name, value) -> console.trace("option [%s] = [%s]", name, value));
            }
            ShellType shellType = step.getShellType();
            String processBuilderCommand = this.parseProcessBuilderCommand(this.command, this.captureType, properties);
            String[] processBuilderCommands = Run.createProcessBuilderCommands(processBuilderCommand, shellType);
            File workingDirectory = Run.parseWorkingDirectory(step.getWorkingDirectory(), environmentVariables, properties);
            console.trace("command [%s]", this.command);
            console.trace("process builder command [%s]", processBuilderCommand);
            console.trace("capture type [%s]", new Object[]{this.captureType});
            console.trace("capture variable [%s]", this.captureVariable);
            console.trace("shell type [%s]", new Object[]{shellType});
            console.trace("working directory [%s]", workingDirectory.getAbsolutePath());
            Matcher matcher = Pattern.compile(PROPERTY_MATCHING_REGEX).matcher(processBuilderCommand);
            while (matcher.find()) {
                property = matcher.group();
                propertyKey = "INPUT_" + property.substring(property.lastIndexOf("{") + 1, property.indexOf("}"));
                console.trace("property [%s] propertyKey [%s]", property, propertyKey);
                if (properties.containsKey(propertyKey)) continue;
                String message = String.format("unresolved command property [%s]", property);
                console.error("%s %s", this.getStep(), message);
                this.setExitCode(1);
                return;
            }
            matcher.reset(workingDirectory.getAbsolutePath());
            while (matcher.find()) {
                property = matcher.group();
                propertyKey = "INPUT_" + property.substring(property.lastIndexOf("{") + 1, property.indexOf("}"));
                console.trace("property [%s] propertyKey [%s]", property, propertyKey);
                if (properties.containsKey(propertyKey)) continue;
                String message = String.format("unresolved working-directory property [%s]", property);
                console.error("%s %s", this.getStep(), message);
                this.setExitCode(1);
                return;
            }
            try {
                this.validator.isValidDirectory(workingDirectory, "working directory either doesn't exit, not a directory, or not accessible");
            }
            catch (ValidatorException e) {
                console.error("%s %s", this.getStep(), e.getMessage());
                this.setExitCode(1);
                return;
            }
            if ("mask".equals(options.get("properties"))) {
                console.log("$ %s", this.command);
            } else {
                console.log("$ %s", processBuilderCommand);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.environment().putAll(environmentVariables);
            processBuilder.directory(workingDirectory);
            processBuilder.command(processBuilderCommands);
            processBuilder.redirectErrorStream(true);
            try {
                PrintStream capturingPrintStream;
                Process process = processBuilder.start();
                StringBuilder outputStringBuilder = new StringBuilder();
                switch (this.captureType) {
                    case APPEND: 
                    case OVERWRITE: {
                        capturingPrintStream = new StringPrintStream(outputStringBuilder);
                        break;
                    }
                    default: {
                        capturingPrintStream = new NoOpPrintStream();
                    }
                }
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    boolean appendCRLF = false;
                    while ((line = bufferedReader.readLine()) != null) {
                        String[] tokens;
                        for (String token : tokens = line.split("\\R")) {
                            if (appendCRLF) {
                                capturingPrintStream.println();
                            }
                            capturingPrintStream.print(token);
                            if (this.captureType == CaptureType.NONE) {
                                console.log("> %s", token);
                            }
                            appendCRLF = true;
                        }
                    }
                }
                capturingPrintStream.close();
                switch (this.captureType) {
                    case APPEND: {
                        String capturedOutput = outputStringBuilder.toString();
                        console.trace("captured output [%s]", capturedOutput);
                        job.getProperties().merge("INPUT_" + this.captureVariable, capturedOutput, (a, b) -> a + b);
                        break;
                    }
                    case OVERWRITE: {
                        String capturedOutput = outputStringBuilder.toString();
                        console.trace("captured output [%s]", capturedOutput);
                        job.getProperties().put("INPUT_" + this.captureVariable, capturedOutput);
                        break;
                    }
                }
                this.setExitCode(process.waitFor());
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(System.out);
                this.setExitCode(1);
            }
        }
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        return "@run command [" + this.command + "]";
    }

    private String parseProcessBuilderCommand(String command, CaptureType captureType, Map<String, String> properties) {
        String processBuilderCommand;
        this.console.trace("parseProcessBuilderCommand command [%s] captureType [%s]", new Object[]{command, captureType});
        switch (captureType) {
            case APPEND: {
                processBuilderCommand = command.substring(0, command.lastIndexOf(">>")).trim();
                break;
            }
            case OVERWRITE: {
                processBuilderCommand = command.substring(0, command.lastIndexOf(">")).trim();
                break;
            }
            default: {
                processBuilderCommand = command;
            }
        }
        processBuilderCommand = RecursiveReplacer.replace(properties, PROPERTY_MATCHING_REGEX, processBuilderCommand);
        this.console.trace("parseProcessBuilderCommand [%s]", processBuilderCommand);
        return processBuilderCommand;
    }

    private static File parseWorkingDirectory(String workingDirectory, Map<String, String> environmentVariables, Map<String, String> properties) {
        return new File(RecursiveReplacer.replace(properties, PROPERTY_MATCHING_REGEX, RecursiveReplacer.replace(environmentVariables, ENVIRONMENT_VARIABLE_MATCHING_REGEX, workingDirectory)));
    }

    private static String[] createProcessBuilderCommands(String command, ShellType shellType) {
        String[] processBuilderCommands;
        switch (shellType) {
            case BASH: {
                processBuilderCommands = new String[]{"bash", "--noprofile", "--norc", "-eo", "pipefail", "-c", command};
                break;
            }
            case SH: {
                processBuilderCommands = new String[]{"sh", "-e", "-c", command};
                break;
            }
            default: {
                processBuilderCommands = new String[]{"bash", "-e", "-c", command};
            }
        }
        return processBuilderCommands;
    }

    @SafeVarargs
    private static Map<String, String> merge(Map<String, String> ... maps) {
        TreeMap<String, String> mergedMap = new TreeMap<String, String>();
        for (Map<String, String> map : maps) {
            mergedMap.putAll(map);
        }
        return mergedMap;
    }
}

