/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.dataformat.bindy.kvp.springboot;

import org.apache.camel.dataformat.bindy.kvp.BindyKeyValuePairDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Camel Bindy data format support
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.dataformat.bindy-kvp")
public class BindyKeyValuePairDataFormatConfiguration {

    /**
     * Whether to use csv fixed or key value pairs mode.
     */
    private BindyType type = BindyType.KeyValue;
    /**
     * Name of model class to use.
     */
    private String classType;
    /**
     * To configure a default locale to use such as us for united states. To use
     * the JVM platform default locale then use the name default
     */
    private String locale;

    public BindyType getType() {
        return type;
    }

    public void setType(BindyType type) {
        this.type = type;
    }

    public String getClassType() {
        return classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}