/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.IHost;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.internal.ui.Messages;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class JavaMonitorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int MIN_UPDATE_PERIOD = 100;
    private Text updatePeriodText;
    private Button legendVisibilityButton;
    private Button wideScopeThreadFilterButton;
    private Button wideScopeSWTResourcesFilterButton;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createUpdatePeriodText(composite);
        this.createTimelineGroup(composite);
        this.createThreadsGroup(composite);
        this.createMemoryGroup(composite);
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.fusesource.ide.jvmmonitor.ui.java_monitor_preference_page_context");
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("UpdatePeriod", this.updatePeriodText.getText());
        this.getPreferenceStore().setValue("LegendVisibility", this.legendVisibilityButton.getSelection());
        this.getPreferenceStore().setValue("WideScopeThreadFilter", this.wideScopeThreadFilterButton.getSelection());
        this.getPreferenceStore().setValue("WideScopeSWTResourcesFilter", this.wideScopeSWTResourcesFilterButton.getSelection());
        this.applyChanges();
        return true;
    }

    private void applyChanges() {
        Integer period = Integer.valueOf(this.updatePeriodText.getText());
        for (IHost host : JvmModel.getInstance().getHosts()) {
            for (IActiveJvm jvm : host.getActiveJvms()) {
                jvm.getMBeanServer().setUpdatePeriod(period);
            }
        }
    }

    protected void performDefaults() {
        String updatePeriod = String.valueOf(this.getPreferenceStore().getDefaultInt("UpdatePeriod"));
        this.updatePeriodText.setText(updatePeriod);
        this.legendVisibilityButton.setSelection(this.getPreferenceStore().getDefaultBoolean("LegendVisibility"));
        this.wideScopeThreadFilterButton.setSelection(this.getPreferenceStore().getDefaultBoolean("WideScopeThreadFilter"));
        this.wideScopeSWTResourcesFilterButton.setSelection(this.getPreferenceStore().getDefaultBoolean("WideScopeSWTResourcesFilter"));
        super.performDefaults();
    }

    private void createUpdatePeriodText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.updatePeriodLabel);
        this.updatePeriodText = new Text(composite, 2048);
        this.updatePeriodText.setText(String.valueOf(this.getPreferenceStore().getInt("UpdatePeriod")));
        this.updatePeriodText.setLayoutData((Object)new GridData(768));
        this.updatePeriodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaMonitorPreferencePage.this.validateUpdatePeriod();
            }
        });
    }

    private void createTimelineGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.timelineGroupLabel);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.legendVisibilityButton = new Button((Composite)group, 32);
        this.legendVisibilityButton.setText(Messages.showLegendLabel);
        this.legendVisibilityButton.setSelection(this.getPreferenceStore().getBoolean("LegendVisibility"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.legendVisibilityButton.setLayoutData((Object)gridData);
    }

    private void createThreadsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.threadsGroupLabel);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.wideScopeThreadFilterButton = new Button((Composite)group, 32);
        this.wideScopeThreadFilterButton.setText(Messages.wideScopeThreadFilterLabel);
        this.wideScopeThreadFilterButton.setSelection(this.getPreferenceStore().getBoolean("WideScopeThreadFilter"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.wideScopeThreadFilterButton.setLayoutData((Object)gridData);
    }

    private void createMemoryGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.memoryGroupLabel);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.wideScopeSWTResourcesFilterButton = new Button((Composite)group, 32);
        this.wideScopeSWTResourcesFilterButton.setText(Messages.wideScopeSWTResourceFilterLabel);
        this.wideScopeSWTResourcesFilterButton.setSelection(this.getPreferenceStore().getBoolean("WideScopeSWTResourcesFilter"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.wideScopeSWTResourcesFilterButton.setLayoutData((Object)gridData);
    }

    void validateUpdatePeriod() {
        String period = this.updatePeriodText.getText();
        if (period.isEmpty()) {
            this.setMessage(Messages.updatePeriodNotEnteredMsg, 2);
            return;
        }
        try {
            Integer.parseInt(period);
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage(Messages.illegalUpdatePeriodMsg, 3);
            return;
        }
        if (Integer.valueOf(period) < 100) {
            this.setMessage(Messages.updatePeriodOutOfRangeMsg, 3);
            return;
        }
        this.setMessage(null);
    }
}

