/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.fusesource.ide.jvmmonitor.core.ISnapshot;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.Messages;

public class CopyAction
extends Action
implements ISelectionChangedListener {
    private String textData;
    private List<String> filesData;

    public CopyAction() {
        this.setText(Messages.copyLabel);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setEnabled(false);
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.filesData = new ArrayList<String>();
    }

    public static CopyAction createCopyAction(IActionBars actionBars) {
        IAction action = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        if (action instanceof CopyAction) {
            return (CopyAction)action;
        }
        CopyAction copyAction = new CopyAction();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyAction);
        return copyAction;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof StructuredSelection)) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        this.filesData.clear();
        Object[] objectArray = ((StructuredSelection)event.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            String string = this.getString(element);
            buffer.append(string);
            if (element instanceof ISnapshot) {
                this.filesData.add(string);
            }
            ++n2;
        }
        this.textData = buffer.toString();
        this.setEnabled(this.textData.length() > 0);
    }

    public void run() {
        if (this.textData == null || this.textData.length() == 0) {
            return;
        }
        Clipboard clipboard = new Clipboard(Display.getDefault());
        if (this.filesData.size() > 0) {
            Object[] clipboardData = new Object[]{this.filesData.toArray(new String[0]), this.textData};
            Transfer[] clipboardDataTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
            clipboard.setContents(clipboardData, clipboardDataTypes);
        } else {
            clipboard.setContents(new Object[]{this.textData}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    protected String getString(Object element) {
        if (element instanceof ISnapshot) {
            return ((ISnapshot)element).getFileStore().toURI().getPath();
        }
        return element.toString();
    }
}

