/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.fusesource.ide.jvmmonitor.core.dump.IProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.ui.editors.AbstractDumpEditor;
import org.fusesource.ide.jvmmonitor.internal.ui.editors.Messages;

public class InfoPage
extends Composite {
    private static final String RUNTIME_NAME_SPLITTER = "@";
    private Text hostnameText;
    private Text pidText;
    private Text mainClassText;
    private Text argumentsText;
    private Text dateText;
    private Text commentsText;
    AbstractDumpEditor editor;
    private String lastComments;
    private Section runtimeSection;

    public InfoPage(AbstractDumpEditor editor, Composite parent) {
        super(parent, 0);
        this.editor = editor;
        this.createControls(this, new FormToolkit(Display.getDefault()));
    }

    protected boolean isDirty() {
        return this.lastComments != null && !this.lastComments.equals(this.commentsText.getText());
    }

    /*
     * Exception decompiling
     */
    protected void doSave(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void refresh(IProfileInfo info) {
        if (info == null || this.dateText == null || this.mainClassText == null || this.pidText == null || this.hostnameText == null || this.argumentsText == null) {
            return;
        }
        this.runtimeSection.setExpanded(true);
        this.dateText.setText(info.getDate());
        this.mainClassText.setText(info.getMainClass());
        String runtime = info.getRuntime();
        if (runtime.contains(RUNTIME_NAME_SPLITTER)) {
            String[] elements = runtime.split(RUNTIME_NAME_SPLITTER);
            this.pidText.setText(elements[0]);
            this.hostnameText.setText(elements[1]);
        }
        this.argumentsText.setText(info.getArguments().replace(" -", "\n-"));
        String comments = info.getComments();
        this.commentsText.setText(comments);
        this.lastComments = comments;
    }

    protected void focusCommnentsText() {
        this.commentsText.forceFocus();
    }

    private void createControls(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new FillLayout());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.getBody().setLayout((Layout)new GridLayout(1, false));
        this.createRuntimeSection(form.getBody(), toolkit);
        this.createSnapshotSection(form.getBody(), toolkit);
    }

    private void createRuntimeSection(Composite parent, FormToolkit toolkit) {
        this.runtimeSection = toolkit.createSection(parent, 258);
        this.runtimeSection.setText(Messages.runtimeSectionLabel);
        this.runtimeSection.setLayoutData((Object)new GridData(768));
        Composite composite = toolkit.createComposite((Composite)this.runtimeSection);
        this.runtimeSection.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.hostnameText = this.createText(composite, toolkit, Messages.hostnameLabel);
        this.pidText = this.createText(composite, toolkit, Messages.pidLabel);
        this.mainClassText = this.createText(composite, toolkit, Messages.mainClassLabel);
        this.argumentsText = this.createText(composite, toolkit, Messages.argumentsLabel);
    }

    private void createSnapshotSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.snapshotSectionLabel);
        section.setLayoutData((Object)new GridData(1808));
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.dateText = this.createText(composite, toolkit, Messages.dateLabel);
        this.commentsText = this.createEditableText(composite, toolkit, Messages.commentsLabel);
        this.commentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfoPage.this.editor.firePropertyChange(257);
            }
        });
    }

    private Text createText(Composite parent, FormToolkit toolkit, String title) {
        Label label = toolkit.createLabel(parent, title, 0);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = toolkit.createText(parent, "", 2112);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Text createEditableText(Composite parent, FormToolkit toolkit, String title) {
        Label label = toolkit.createLabel(parent, title, 0);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = toolkit.createText(parent, "", 2626);
        text.setLayoutData((Object)new GridData(1808));
        return text;
    }
}

